/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.impex;

import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.impex.ImportFileLister;
import com.ontotext.forest.impex.ImportRunnableTask;
import com.ontotext.forest.impex.ImportSettings;
import com.ontotext.forest.impex.ImportStatusService;
import com.ontotext.forest.impex.ParallelAwareImporter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileImportRunnableTask
extends ImportRunnableTask {
    private final File importFile;
    private final String relativeFileName;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected FileImportRunnableTask(SemanticRepository repo, boolean isLocal, File importFile, String fileName, RDFFormat fileFormat, ImportSettings settings, ImportStatusService importStatusService, Map<String, Map<String, ImportRunnableTask>> tasksToInterrupt) {
        super(repo, isLocal, fileFormat, settings, importStatusService, tasksToInterrupt);
        this.importFile = importFile;
        this.relativeFileName = fileName;
    }

    @Override
    protected String getEntryName() {
        return this.relativeFileName;
    }

    @Override
    protected void load(ParallelAwareImporter importer) throws Exception {
        if (!this.importFile.exists()) {
            throw new RuntimeException("File not found. Was it deleted manually?");
        }
        importer.setUserFilename(this.getEntryName());
        importer.add(this.importFile, this.settings.getBaseURI(), this.fileFormat, (Resource[])this.settings.getContextResources());
    }

    @Override
    protected void update(String fileName, String msg) {
        super.update(fileName, msg);
        if (this.importFile.isDirectory()) {
            try {
                ImportFileLister.listRDFFiles(this.importFile.toPath(), true).keySet().forEach(path -> super.update(this.getRelativeEntryName((Path)path), msg));
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
        }
    }

    @Override
    protected void updateError(String fileName, String msg) {
        if (this.importFile.isDirectory()) {
            try {
                ImportFileLister.listRDFFiles(this.importFile.toPath(), true).keySet().forEach(path -> super.updateError(this.getRelativeEntryName((Path)path), ""));
            }
            catch (IOException e) {
                this.logger.error(e.getMessage());
            }
        }
        super.updateError(fileName, msg);
    }

    private String getRelativeEntryName(Path path) {
        return this.relativeFileName + path.toString().substring(this.importFile.toString().length());
    }
}

