/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder.functions;

import com.ontotext.graphql.responder.functions.SimpleQueryInvoker;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.IterateOverQuery;
import com.ontotext.models.query.Query;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.rdf.EntityPool;
import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.sparql.SparqlQueryInvoker;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Objects;

public class StorePresenceQueryInvoker {
    private final SimpleQueryInvoker simpleQuery;

    public StorePresenceQueryInvoker(Endpoint endpoint, SparqlQueryInvoker sparqlInvoker) {
        this.simpleQuery = new SimpleQueryInvoker(Objects.requireNonNull(() -> endpoint, "'endpoint' argument shouldn't be null"), Objects.requireNonNull(sparqlInvoker, "'sparqlInvoker' argument shouldn't be null"));
    }

    public RdfTree executeObjectQuery(SomlSchema schema, Collection<String> ids, boolean silent, OperationBuilderOptions options) {
        Objects.requireNonNull(schema, "Schema cannot be null");
        if (ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("Shape and ids should not be null");
        }
        Shape shape = (Shape)schema.getObjects().get((Object)"Object");
        return this.executeQuery(shape, ids, silent, options);
    }

    public RdfTree executeQuery(Shape shape, Collection<String> ids, boolean silent, OperationBuilderOptions options) {
        if (shape == null || ids == null || ids.isEmpty()) {
            throw new IllegalArgumentException("Shape and ids should not be null");
        }
        Query query = this.createTypeQuery(shape, ids);
        return this.simpleQuery.query(query, silent, options).map(TransformContext::getDataOrFail).orElseGet(() -> ((EntityPool)EntityPoolFactory.defaultPool()).emptyTree());
    }

    private Query createTypeQuery(Shape shape, Collection<String> ids) {
        String shapeId = shape.getId();
        IterateOverQuery query = new IterateOverQuery(ids, shapeId.toLowerCase());
        query.setName(shapeId.toLowerCase());
        query.setReturnType(shapeId);
        query.setReturnTypeInstance(shape);
        query.setArguments(new Arguments());
        Selection typeSelection = new Selection();
        typeSelection.setName("__typename");
        Shape parent = shape.forEachParentShape().findFirst().orElse(shape);
        typeSelection.setDefinedIn(parent.asGraphQl());
        typeSelection.setDefinedInType(parent);
        typeSelection.setSelections(new LinkedList());
        query.setSelections(Collections.singletonList(typeSelection));
        return query;
    }
}

