/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder.functions;

import com.ontotext.graphql.compiler.BuilderTypeDecider;
import com.ontotext.graphql.compiler.DynamicQueryBuilderFactory;
import com.ontotext.graphql.compiler.QueryOptimizer;
import com.ontotext.graphql.compiler.SparqlBuilderType;
import com.ontotext.graphql.responder.GraphQlResponder;
import com.ontotext.graphql.responder.MutationExecutionRequest;
import com.ontotext.graphql.responder.MutationSparqlEndpointInvoker;
import com.ontotext.graphql.responder.QueryExecutionRequest;
import com.ontotext.graphql.responder.QuerySparqlEndpointInvoker;
import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.models.Operation;
import com.ontotext.models.ValidatorOptions;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.data.generation.DataGenerationContext;
import com.ontotext.models.mutation.data.generation.DataGeneratorOptions;
import com.ontotext.models.mutation.data.generation.DataGenerators;
import com.ontotext.models.mutation.data.generation.DefaultDataGenerationOptions;
import com.ontotext.models.query.Query;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.connection.EndpointProvider;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.soaas.common.sparql.SparqlExecutionStep;
import com.ontotext.sparql.SparqlEndpointRequestContext;
import com.ontotext.sparql.SparqlQueryInvoker;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleQueryInvoker
implements Closeable {
    private BuilderTypeDecider queryBuilderTypeDecider = SimpleQueryInvoker.getModeResolver();
    private final GraphQlResponder graphQlResponder;
    private final EndpointProvider endpointProvider;
    private final boolean mutationsEnabled;
    private final DataGenerators dataGenerators = new DataGenerators();
    private final QueryOptimizer queryOptimizer = new QueryOptimizer();

    public SimpleQueryInvoker(EndpointProvider endpointProvider, SparqlQueryInvoker sparqlInvoker) {
        this(endpointProvider, sparqlInvoker, false);
    }

    public SimpleQueryInvoker(EndpointProvider endpointProvider, SparqlQueryInvoker sparqlInvoker, boolean mutationsEnabled) {
        this.endpointProvider = endpointProvider;
        this.mutationsEnabled = mutationsEnabled;
        GraphQlResponder.Builder builder = GraphQlResponder.builder().registerInvoker(new QuerySparqlEndpointInvoker(sparqlInvoker));
        if (mutationsEnabled) {
            builder.registerInvoker(new MutationSparqlEndpointInvoker(sparqlInvoker));
        }
        this.graphQlResponder = builder.build();
    }

    @NotNull
    public BuilderTypeDecider getQueryBuilderTypeDecider() {
        return this.queryBuilderTypeDecider;
    }

    public SimpleQueryInvoker setQueryBuilderTypeDecider(@Nullable BuilderTypeDecider queryBuilderTypeDecider) {
        this.queryBuilderTypeDecider = (BuilderTypeDecider)ObjectsUtil.getOrDefaultGet((Object)queryBuilderTypeDecider, SimpleQueryInvoker::getModeResolver);
        return this;
    }

    public Optional<TransformContext> query(Query query, boolean silent, OperationBuilderOptions options) {
        return this.query(query, silent, options, null);
    }

    public Optional<TransformContext> query(Query query, boolean silent, OperationBuilderOptions options, Endpoint endpointArg) {
        List<SparqlExecutionStep> steps = this.generateSparqlQueries((Operation)query, options);
        if (steps.isEmpty()) {
            return Optional.empty();
        }
        Endpoint localEndpoint = endpointArg;
        if (localEndpoint == null && this.endpointProvider != null) {
            localEndpoint = this.endpointProvider.getEndpoint();
        }
        QueryExecutionRequest request = QueryExecutionRequest.from(query, steps, localEndpoint);
        request.setSilent(silent);
        List<TransformContext> transformContexts = this.graphQlResponder.processRequest(request);
        return Optional.of(transformContexts.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TransformContext> update(Mutation mutation, boolean silent, ValidatorOptions validatorOptions, OperationBuilderOptions options, Endpoint endpointArg) {
        if (!this.mutationsEnabled) {
            throw new UnsupportedOperationException("Mutations are not enabled!");
        }
        OperationResponse response = this.callValueGeneration(mutation);
        if (!response.isValid()) {
            return Optional.of(new TransformContext((Operation)mutation, null, response.getErrorMessages(), 0));
        }
        List<SparqlExecutionStep> steps = this.generateSparqlQueries((Operation)mutation, options);
        if (steps.isEmpty()) {
            return Optional.empty();
        }
        Endpoint localEndpoint = endpointArg;
        if (localEndpoint == null) {
            localEndpoint = this.endpointProvider.getEndpoint();
        }
        MutationExecutionRequest request = MutationExecutionRequest.from(mutation, steps, localEndpoint, validatorOptions, options);
        request.setSilent(silent);
        try {
            List<TransformContext> transformContexts = this.graphQlResponder.processRequest(request);
            Optional<TransformContext> optional = Optional.of(transformContexts.get(0));
            return optional;
        }
        finally {
            this.closeRequest(request);
        }
    }

    private void closeRequest(MutationExecutionRequest executionRequest) {
        for (UpdateExecution execution : executionRequest.getExecutions()) {
            execution.getConnectionReusePolicy().close();
        }
    }

    private OperationResponse callValueGeneration(Mutation mutation) {
        DataGenerationContext ctx = new DataGenerationContext(mutation.getSchema(), (DataGeneratorOptions)DefaultDataGenerationOptions.INSTANCE).setData(new HashMap());
        return this.dataGenerators.generate((Operation)mutation, ctx);
    }

    private List<SparqlExecutionStep> generateSparqlQueries(Operation operation, OperationBuilderOptions options) {
        DynamicQueryBuilderFactory factory = new DynamicQueryBuilderFactory(this.queryOptimizer, this.queryBuilderTypeDecider, options);
        return factory.createBuilder(operation).buildQuery((Object)operation).getSteps();
    }

    @NotNull
    private static BuilderTypeDecider getModeResolver() {
        return operation -> SparqlEndpointRequestContext.isSubQueryMode() ? SparqlBuilderType.SUBQUERY : SparqlBuilderType.SPLIT;
    }

    @Override
    public void close() {
        this.graphQlResponder.close();
    }
}

