/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.models.SomlSchema;
import com.ontotext.soaas.common.sparql.SparqlExecutionStep;
import com.ontotext.sparql.SparqlRequest;
import com.ontotext.sparql.SparqlRequestBuilder;
import com.ontotext.sparql.UpdateRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class UpdateStep
implements SparqlRequestBuilder<String> {
    private final String requestId;
    private final String query;
    private boolean silent = false;
    @Nullable
    private Boolean includeInferred;
    @Nullable
    private Boolean expandSameAs;

    public UpdateStep(String requestId, String query) {
        this.requestId = requestId;
        this.query = query;
    }

    public static List<UpdateStep> from(List<SparqlExecutionStep> executionSteps) {
        List steps = executionSteps.stream().filter(SparqlExecutionStep::isUpdate).collect(Collectors.toList());
        return steps.stream().map(UpdateStep::toUpdateStep).collect(Collectors.toList());
    }

    private static UpdateStep toUpdateStep(SparqlExecutionStep executionStep) {
        return new UpdateStep(executionStep.getId(), executionStep.getQuery(null));
    }

    public String getQuery() {
        return this.query;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public SparqlRequest<String> toSparqlRequest(SomlSchema schema) {
        UpdateRequest request = new UpdateRequest(this.requestId, this.query);
        if (this.isSilent()) {
            request.disableRequestLogging();
        }
        request.setExpandOverSameAs(this.getExpandSameAs());
        request.setIncludeInferred(this.getIncludeInferred());
        return request;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    @Nullable
    public Boolean getIncludeInferred() {
        return this.includeInferred;
    }

    public UpdateStep setIncludeInferred(@Nullable Boolean includeInferred) {
        this.includeInferred = includeInferred;
        return this;
    }

    @Nullable
    public Boolean getExpandSameAs() {
        return this.expandSameAs;
    }

    public UpdateStep setExpandSameAs(@Nullable Boolean expandSameAs) {
        this.expandSameAs = expandSameAs;
        return this;
    }
}

