/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.SimpleExecution;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.sparql.BulkUpdateRequest;
import com.ontotext.sparql.SparqlRequest;
import com.ontotext.sparql.UpdateRequest;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class SimpleUpdate
extends SimpleExecution {
    private final List<String> updates;

    public SimpleUpdate(Endpoint endpoint, List<String> bulkUpdate) {
        super(UUID.randomUUID().toString(), endpoint);
        this.updates = Objects.requireNonNull(bulkUpdate);
    }

    @Override
    public SparqlRequest<String> toSparqlRequest() {
        BulkUpdateRequest request = new BulkUpdateRequest(this.getRequestId(), this.updates.stream().map(update -> new UpdateRequest(this.getRequestId(), update)).collect(Collectors.toList()));
        if (this.isSilent()) {
            request.disableRequestLogging();
        }
        request.setExpandOverSameAs(this.getExpandSameAs());
        request.setIncludeInferred(this.getIncludeInferred());
        return request;
    }
}

