/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.EndpointExecutionResponse;
import com.ontotext.graphql.responder.EndpointInvoker;
import com.ontotext.graphql.responder.EndpointInvokerResolver;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.graphql.responder.ExecutionRequestProcessor;
import com.ontotext.graphql.responder.ParallelExecutionRequestProcessor;
import com.ontotext.graphql.responder.QueryExecution;
import com.ontotext.graphql.responder.QueryExecutionRequest;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.rdf.RdfTree;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class QueryRequestProcessor
extends ParallelExecutionRequestProcessor<QueryExecution, QueryExecutionRequest>
implements ExecutionRequestProcessor {
    @Override
    public boolean accept(ExecutionRequest<?> request) {
        return request instanceof QueryExecutionRequest;
    }

    @Override
    protected List<Callable<List<TransformContext>>> createEndpointRequest(Endpoint endpoint, List<QueryExecution> requests, QueryExecutionRequest executionContext, EndpointInvokerResolver invokerResolver) {
        return Collections.singletonList(() -> {
            ExecutionRequest<QueryExecution> subRequest = executionContext.createCopyFor(requests);
            Optional<EndpointInvoker> invoker = invokerResolver.resolve(endpoint, executionContext);
            if (invoker.isPresent()) {
                List resultContexts = invoker.get().invoke(endpoint, subRequest);
                return resultContexts.stream().map(this::toTransformContext).collect(Collectors.toList());
            }
            return Collections.singletonList(this.respondWithUnsupportedRequest(endpoint));
        });
    }

    protected TransformContext respondWithUnsupportedRequest(Endpoint endpoint) {
        return new TransformContext(Collections.singletonList("Unsupported invocation for endpoint: " + endpoint.getClass().getName() + ":" + String.valueOf(endpoint)), 0);
    }

    protected TransformContext toTransformContext(EndpointExecutionResponse<RdfTree> response) {
        int index = response.getRequest().getIndex();
        if (response.isValid()) {
            return new TransformContext(response.getOperation(), response.getData(), response.getExtensions(), index);
        }
        return new TransformContext(response.getOperation(), response.getErrors(), index);
    }
}

