/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.BaseExecutionRequest;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.graphql.responder.QueryExecution;
import com.ontotext.graphql.responder.QueryStep;
import com.ontotext.graphql.responder.RequestExtensionsLoader;
import com.ontotext.models.Operation;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.Query;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.sparql.SparqlExecutionStep;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.commons.lang3.ObjectUtils;

public class QueryExecutionRequest
extends BaseExecutionRequest<QueryExecution> {
    private List<QueryExecution> queries = new LinkedList<QueryExecution>();

    public QueryExecutionRequest(SomlSchema somlSchema) {
        super(Objects.requireNonNull(somlSchema, "Soml schema is required"), null);
    }

    public static QueryExecutionRequest from(Query query, List<SparqlExecutionStep> executionSteps, Endpoint endpoint) {
        QueryExecutionRequest executionRequest = new QueryExecutionRequest(query.getSchema());
        executionRequest.addQuery((Operation)query, QueryStep.from(executionSteps), endpoint);
        return executionRequest;
    }

    public void addQuery(Operation graphQuery, List<QueryStep> remoteQuery, Endpoint endpoint) {
        if (!(graphQuery instanceof Query)) {
            throw new IllegalArgumentException("Cannot add query execution step for mutation");
        }
        QueryExecution queryExecution = new QueryExecution(UUID.randomUUID().toString(), Objects.requireNonNull((Query)graphQuery, "Graph query is required"), Objects.requireNonNull(remoteQuery, "Remote query is required"), Objects.requireNonNull(endpoint, "Endpoint is required"));
        RequestExtensionsLoader.loadQueryPostProcessors().forEach(queryExecution::addPostProcessor);
        this.addExecution(queryExecution);
    }

    @Override
    public void addExecution(QueryExecution execution) {
        execution.setSilent(this.isSilent());
        execution.setIndex(this.queries.size());
        execution.setTxId((String)ObjectUtils.getIfNull((Object)execution.getTxId(), this::getTxId));
        this.queries.add(execution);
    }

    @Override
    public List<QueryExecution> getExecutions() {
        return Collections.unmodifiableList(this.queries);
    }

    @Override
    public ExecutionRequest<QueryExecution> createCopyFor(List<QueryExecution> executions) {
        QueryExecutionRequest executionContext = new QueryExecutionRequest(this.getSomlSchema());
        executions.stream().map(QueryExecution::getTxId).findFirst().ifPresent(id -> {
            if (!executions.stream().map(QueryExecution::getTxId).allMatch(Predicate.isEqual(id))) {
                throw new IllegalArgumentException("All queries must have the same transaction id");
            }
            executionContext.setTxId((String)id);
        });
        executionContext.queries.addAll(executions);
        executionContext.setSilent(this.isSilent());
        return executionContext;
    }

    @Override
    public void setSilent(boolean silent) {
        super.setSilent(silent);
        this.queries.forEach(queryExecution -> queryExecution.setSilent(silent));
    }
}

