/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.UpdateStep;
import com.ontotext.graphql.responder.ValidationUpdateStep;
import com.ontotext.soaas.common.concurrent.ExecutionResponse;
import com.ontotext.sparql.QueryRequest;
import com.ontotext.sparql.SparqlConnection;
import com.ontotext.sparql.SparqlRequest;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

class MutationRevertRequest
implements SparqlRequest<Object> {
    private static final String FETCH_CHANGES_TEMPLATE = "CONSTRUCT {\n    ?s ?p ?o .\n}\nFROM <http://www.ontotext.com/%s/%s>\nWHERE {\n    ?s ?p ?o .\n}";
    public static final String ADDED = "added";
    public static final String REMOVED = "removed";
    private final String reqId = UUID.randomUUID().toString();
    private List<String> ids;
    private UpdateExecution execution;

    public MutationRevertRequest(UpdateExecution execution) {
        this.execution = execution;
    }

    public String getRequestId() {
        return this.reqId;
    }

    public Object getQuery() {
        return "Revert updates with id: " + String.valueOf(this.ids);
    }

    public ExecutionResponse execute(SparqlConnection connection) {
        this.ids = this.execution.getUpdateSteps().stream().filter(step -> !(step instanceof ValidationUpdateStep)).map(UpdateStep::getRequestId).distinct().collect(Collectors.toList());
        if (this.ids.isEmpty()) {
            return ExecutionResponse.of(null, (String)this.getRequestId());
        }
        this.ids.stream().map(this::requestAdded).forEach(req -> connection.executeConstruct(req, (RDFHandler)new StatementConsumer(arg_0 -> ((SparqlConnection)connection).removeStatement(arg_0))));
        this.ids.stream().map(this::requestDeleted).forEach(req -> connection.executeConstruct(req, (RDFHandler)new StatementConsumer(arg_0 -> ((SparqlConnection)connection).addStatement(arg_0))));
        return ExecutionResponse.of(null, (String)this.getRequestId());
    }

    private QueryRequest requestAdded(String id) {
        return new QueryRequest(this.getRequestId(), this.getAdded(id), Collections.emptyMap(), null);
    }

    private QueryRequest requestDeleted(String id) {
        return new QueryRequest(this.getRequestId(), this.getRemoved(id), Collections.emptyMap(), null);
    }

    public boolean isShaclEnabled() {
        return false;
    }

    private String getAdded(String id) {
        return String.format(FETCH_CHANGES_TEMPLATE, ADDED, id);
    }

    private String getRemoved(String id) {
        return String.format(FETCH_CHANGES_TEMPLATE, REMOVED, id);
    }

    private static class StatementConsumer
    extends AbstractRDFHandler {
        private Consumer<Statement> consumer;

        public StatementConsumer(Consumer<Statement> consumer) {
            this.consumer = consumer;
        }

        public void handleStatement(Statement statement) throws RDFHandlerException {
            this.consumer.accept(statement);
        }
    }
}

