/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.EndpointExecutionResponse;
import com.ontotext.graphql.responder.EndpointInvoker;
import com.ontotext.graphql.responder.EndpointInvokerResolver;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.graphql.responder.ExecutionRequestProcessor;
import com.ontotext.graphql.responder.MutationExecutionRequest;
import com.ontotext.graphql.responder.MutationResponse;
import com.ontotext.graphql.responder.ParallelExecutionRequestProcessor;
import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.models.Operation;
import com.ontotext.models.extensions.ConfigurationResolver;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.plugin.Inject;
import com.ontotext.sparql.ConnectionReusePolicies;
import com.ontotext.sparql.ConnectionReusePolicy;
import com.ontotext.sparql.TrackChangesTransactionPolicy;
import com.ontotext.sparql.TransactionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;

public class MutationRequestProcessor
extends ParallelExecutionRequestProcessor<UpdateExecution, MutationExecutionRequest>
implements ExecutionRequestProcessor {
    private static final String FORCE_MULTI_REPOSITORY_SEQUENTIAL_REQUESTS = "graphql.mutation.forceMultiRepositorySequentialRequests";
    private static final String GDB_FORCE_MULTI_REPOSITORY_SEQUENTIAL_REQUESTS = "graphdb.graphql.mutation.forceMultiRepositorySequentialRequests";
    private Boolean forceMultiRepositorySequentialRequests;

    @Override
    public boolean accept(ExecutionRequest<?> request) {
        return request instanceof MutationExecutionRequest;
    }

    @Override
    @Inject
    public void setConfiguration(ConfigurationResolver configuration) {
        super.setConfiguration(configuration);
        if (configuration == null) {
            return;
        }
        this.forceMultiRepositorySequentialRequests = (Boolean)configuration.resolve(GDB_FORCE_MULTI_REPOSITORY_SEQUENTIAL_REQUESTS, Boolean.class, null);
        if (this.forceMultiRepositorySequentialRequests == null) {
            this.forceMultiRepositorySequentialRequests = (Boolean)configuration.resolve(FORCE_MULTI_REPOSITORY_SEQUENTIAL_REQUESTS, Boolean.class, (Object)Boolean.FALSE);
        }
    }

    @Override
    protected boolean forceSequentialRequests() {
        return Objects.requireNonNullElseGet(this.forceMultiRepositorySequentialRequests, () -> super.forceSequentialRequests());
    }

    @Override
    protected List<Callable<List<TransformContext>>> createEndpointRequest(Endpoint endpoint, List<UpdateExecution> requests, MutationExecutionRequest request, EndpointInvokerResolver invokerResolver) {
        return Collections.singletonList(() -> {
            this.setAsInSingleTransaction(requests);
            this.enableTrackChanges(requests);
            try {
                ExecutionRequest<UpdateExecution> subRequest = request.createCopyFor(requests);
                EndpointInvoker invoker = invokerResolver.resolve(endpoint, request).orElse(null);
                if (invoker != null) {
                    List<EndpointExecutionResponse<MutationResponse>> resultContexts = invoker.invoke(endpoint, subRequest);
                    List<TransformContext> list = this.convertToMutationResponses(resultContexts, subRequest);
                    return list;
                }
                List<TransformContext> list = Collections.singletonList(this.respondWithUnsupportedRequest(endpoint));
                return list;
            }
            finally {
                requests.forEach(execution -> execution.getConnectionReusePolicy().close());
            }
        });
    }

    protected TransformContext respondWithUnsupportedRequest(Endpoint endpoint) {
        return new TransformContext(Collections.singletonList("Unsupported invocation for endpoint: " + endpoint.getClass().getName() + ":" + String.valueOf(endpoint)), 0);
    }

    protected List<TransformContext> convertToMutationResponses(List<EndpointExecutionResponse<MutationResponse>> contexts, ExecutionRequest<UpdateExecution> request) {
        ArrayList<TransformContext> resultContexts = new ArrayList<TransformContext>(contexts.size());
        List<UpdateExecution> steps = request.getExecutions();
        assert (contexts.size() == steps.size());
        for (int i = 0; i < contexts.size(); ++i) {
            EndpointExecutionResponse<MutationResponse> response = contexts.get(i);
            UpdateExecution updateExecution = steps.get(i);
            TransformContext transformContext = this.convertToMutationResponse(updateExecution, response);
            transformContext.addWarnings(request.getWarnings());
            resultContexts.add(transformContext);
        }
        return resultContexts;
    }

    protected TransformContext convertToMutationResponse(UpdateExecution request, EndpointExecutionResponse<MutationResponse> response) {
        int index = response.getRequest().getIndex();
        if (response.isValid()) {
            MutationResponse responseData = response.getData();
            RdfTree rdfTree = responseData.getQueryData();
            return new TransformContext((Operation)request.getOperation(), rdfTree, response.getExtensions(), index);
        }
        if (response.getData() != null) {
            return new TransformContext((Operation)request.getOperation(), response.getData().getQueryData(), response.getErrors(), index);
        }
        return new TransformContext((Operation)request.getOperation(), response.getErrors(), index);
    }

    protected void setAsInSingleTransaction(List<UpdateExecution> steps) {
        ConnectionReusePolicy connectionReusePolicy = ConnectionReusePolicies.serializedSingleConnection();
        for (UpdateExecution step : steps) {
            step.setConnectionReusePolicy(connectionReusePolicy);
        }
    }

    protected void enableTrackChanges(List<UpdateExecution> steps) {
        for (UpdateExecution execution : steps) {
            if (!execution.needToFetchChanges()) continue;
            execution.setTransactionPolicy((TransactionPolicy)new TrackChangesTransactionPolicy(execution.getTransactionPolicy()));
        }
    }
}

