/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.BaseExecutionRequest;
import com.ontotext.graphql.responder.ExecutionRequest;
import com.ontotext.graphql.responder.QueryStep;
import com.ontotext.graphql.responder.RequestExtensionsLoader;
import com.ontotext.graphql.responder.UpdateExecution;
import com.ontotext.graphql.responder.UpdateStep;
import com.ontotext.graphql.responder.validation.MutationActiveValidator;
import com.ontotext.graphql.responder.validation.PostMutationProcessor;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.ValidatorOptions;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.security.Role;
import com.ontotext.soaas.common.connection.Endpoint;
import com.ontotext.soaas.common.sparql.OperationBuilderOptions;
import com.ontotext.soaas.common.sparql.SparqlExecutionStep;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.commons.lang3.ObjectUtils;

public class MutationExecutionRequest
extends BaseExecutionRequest<UpdateExecution> {
    private final Set<Role> roles;
    private final ValidatorOptions validatorOptions;
    private final OperationBuilderOptions options;
    private boolean healthRequest = false;
    private List<MutationActiveValidator> validators = new LinkedList<MutationActiveValidator>();
    private List<PostMutationProcessor> postProcessors = new LinkedList<PostMutationProcessor>();
    private List<UpdateExecution> updates = new LinkedList<UpdateExecution>();

    public MutationExecutionRequest(SomlSchema soml, OperationBuilderOptions options) {
        this(soml, ValidatorOptions.emptyOptions(), options);
    }

    public MutationExecutionRequest(SomlSchema soml, ValidatorOptions validatorOptions, OperationBuilderOptions options) {
        this(soml, null, Collections.emptySet(), validatorOptions, options);
    }

    public MutationExecutionRequest(SomlSchema soml, ShaclSchema shacl, Set<Role> roles, ValidatorOptions validatorOptions, OperationBuilderOptions options) {
        super(soml, shacl);
        this.roles = roles;
        this.validatorOptions = validatorOptions;
        this.options = options;
        this.addDefaultExtensions();
    }

    protected void addDefaultExtensions() {
        RequestExtensionsLoader.loadValidators().forEach(this::addValidation);
        RequestExtensionsLoader.loadMutationPostProcessors().forEach(this::addPostProcessor);
    }

    public static MutationExecutionRequest from(Mutation mutation, List<SparqlExecutionStep> executionSteps, Endpoint endpoint, ValidatorOptions validatorOptions, OperationBuilderOptions options) {
        MutationExecutionRequest executionRequest = new MutationExecutionRequest(mutation.getSchema(), validatorOptions, options);
        executionRequest.addOperation(mutation, UpdateStep.from(executionSteps), QueryStep.from(executionSteps), endpoint);
        return executionRequest;
    }

    @Override
    public ExecutionRequest<UpdateExecution> createCopyFor(List<UpdateExecution> executions) {
        MutationExecutionRequest executionContext = new MutationExecutionRequest(this.getSomlSchema(), this.getShaclSchema(), this.roles, this.validatorOptions, this.options);
        Optional<String> tx = executions.stream().map(UpdateExecution::getTxId).findFirst();
        tx.ifPresent(id -> {
            if (!executions.stream().map(UpdateExecution::getTxId).allMatch(Predicate.isEqual(id))) {
                throw new IllegalArgumentException("All updates must have the same transaction id");
            }
            executionContext.setTxId((String)id);
        });
        executionContext.updates.addAll(executions);
        executionContext.setSilent(this.isSilent());
        executionContext.setHealthRequest(this.isHealthRequest());
        return executionContext;
    }

    @Override
    public void addExecution(UpdateExecution execution) {
        execution.setSilent(this.isSilent());
        execution.initialize();
        execution.setIndex(this.updates.size());
        execution.setTxId((String)ObjectUtils.getIfNull((Object)execution.getTxId(), this::getTxId));
        this.updates.add(execution);
    }

    @Override
    public List<UpdateExecution> getExecutions() {
        return this.updates;
    }

    public void addOperation(Mutation operation, List<UpdateStep> updateSteps, List<QueryStep> querySteps, Endpoint endpoint) {
        UpdateExecution updateExecution = new UpdateExecution(UUID.randomUUID().toString(), endpoint, this.getSomlSchema(), this.getShaclSchema(), this.options);
        updateExecution.setRequest(this);
        updateExecution.setRoles(this.roles);
        updateExecution.setValidatorOptions(this.validatorOptions);
        updateExecution.setOperation(operation);
        updateExecution.setQuery(operation.toQuery(), querySteps);
        updateSteps.forEach(updateExecution::addUpdateStep);
        this.addExecution(updateExecution);
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public ValidatorOptions getValidatorOptions() {
        return this.validatorOptions;
    }

    public OperationBuilderOptions getOptions() {
        return this.options;
    }

    @Override
    public void setSilent(boolean silent) {
        super.setSilent(silent);
        this.updates.forEach(updateExecution -> updateExecution.setSilent(silent));
    }

    public boolean isHealthRequest() {
        return this.healthRequest;
    }

    public void setHealthRequest(boolean healthRequest) {
        this.healthRequest = healthRequest;
    }

    public List<MutationActiveValidator> getValidators() {
        return this.validators;
    }

    public void addValidation(MutationActiveValidator validator) {
        this.validators.add(validator);
    }

    public List<PostMutationProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public void addPostProcessor(PostMutationProcessor postMutationProcessor) {
        this.postProcessors.add(postMutationProcessor);
    }

    public boolean hasPostCommitValidator() {
        return this.getValidators().stream().anyMatch(validator -> validator.getPhase() == MutationActiveValidator.Phase.POST_COMMIT);
    }
}

