/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphql.responder;

import com.ontotext.graphql.responder.EndpointExecutionResponse;
import com.ontotext.graphql.responder.PostQueryProcessor;
import com.ontotext.graphql.responder.QueryExecution;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.Query;
import com.ontotext.soaas.common.rdf.RdfTree;
import com.ontotext.soaas.common.rdf.Triple;
import com.ontotext.sparql.SparqlEndpoint;
import com.ontotext.sparql.SparqlQueryInvoker;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.Value;

public class ExplainPostQueryProcessor
implements PostQueryProcessor {
    @Override
    public OperationResponse process(EndpointExecutionResponse<RdfTree> queryResponse, QueryExecution request, SparqlEndpoint endpoint, SparqlQueryInvoker sparqlInvoker) {
        Query query = request.getGraphQuery();
        Arguments arguments = query.getArguments();
        if (!query.isValid() || arguments == null || arguments.isEmpty()) {
            return OperationResponse.EMPTY;
        }
        boolean isExplainQuery = arguments.isFromExplainGraph();
        boolean isSparqlQuery = arguments.isFromSparqlGraph();
        if (!isExplainQuery && !isSparqlQuery) {
            return OperationResponse.EMPTY;
        }
        query.getSelections().forEach(selection -> selection.setRequestedByUser(false));
        RdfTree data = queryResponse.getData();
        Triple triple = this.getTripleOrThrow(data);
        data.remove(triple.getSubject(), triple.getPredicate(), triple.getObject());
        if (query.isCountSelection()) {
            data.add(triple.getSubject(), triple.getPredicate(), (Object)0);
        }
        queryResponse.getExtensions().put(isExplainQuery ? "plan" : "sparql", this.generateExtensionResult(triple, query));
        return OperationResponse.EMPTY;
    }

    private Triple getTripleOrThrow(RdfTree data) {
        return (Triple)data.getAllTriples().stream().findFirst().orElseThrow(() -> new IllegalStateException(this.getClass().getSimpleName() + " fail: No triple found"));
    }

    private Map<String, String> generateExtensionResult(Triple triple, Query query) {
        String string;
        LinkedHashMap<String, String> queryResult = new LinkedHashMap<String, String>();
        Object object = triple.getObject();
        if (object instanceof Value) {
            Value value = (Value)object;
            string = value.stringValue();
        } else {
            string = object.toString();
        }
        String result = string;
        queryResult.put(query.getResponseName(), result);
        return queryResult;
    }
}

