/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.serializer.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.spec.mapping.PrefixManager;
import it.unibz.inf.ontop.spec.mapping.TargetAtom;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPMapping;
import it.unibz.inf.ontop.spec.mapping.pp.SQLPPTriplesMap;
import it.unibz.inf.ontop.spec.mapping.serializer.MappingSerializer;
import it.unibz.inf.ontop.spec.mapping.serializer.impl.TargetQueryRenderer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;

public class OntopNativeMappingSerializer
implements MappingSerializer {
    public void write(File file, SQLPPMapping ppMapping) throws IOException {
        PrefixManager prefixManager = ppMapping.getPrefixManager();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            Map prefixMap = prefixManager.getPrefixMap();
            if (!prefixMap.isEmpty()) {
                writer.write(prefixMap.entrySet().stream().map(e -> (String)e.getKey() + (((String)e.getKey()).length() >= 9 ? "\t" : "\t\t") + (String)e.getValue()).collect(Collectors.joining("\n", "[PrefixDeclaration]\n", "\n\n")));
            }
            TargetQueryRenderer targetQueryRenderer = new TargetQueryRenderer(prefixManager);
            writer.write(ppMapping.getTripleMaps().stream().map(ax -> this.renderTriplesMap((SQLPPTriplesMap)ax, targetQueryRenderer)).collect(Collectors.joining("\n", "[MappingDeclaration] @collection [[\n", "]]\n\n")));
        }
        catch (IOException e2) {
            throw new IOException(String.format("Error while saving the OBDA model to the file located at %s.\nMake sure you have the write permission at the location specified.", file.getAbsolutePath()));
        }
    }

    private String renderTriplesMap(SQLPPTriplesMap axiom, TargetQueryRenderer targetQueryRenderer) {
        return "mappingId\t" + axiom.getId() + "\ntarget\t\t" + targetQueryRenderer.encode((ImmutableList<TargetAtom>)axiom.getTargetAtoms()) + "\nsource\t\t" + axiom.getSourceQuery().getSQL().replaceAll("\t", "   ").replaceAll("\n", "\n\t\t\t") + "\n";
    }
}

