/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.http;

import com.ontotext.graphdb.Config;
import jakarta.servlet.http.HttpServletRequest;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;

class X509UsernameExtractor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SubjectDnX509PrincipalExtractor principalExtractor = new SubjectDnX509PrincipalExtractor();

    X509UsernameExtractor() {
        this.principalExtractor.setSubjectDnRegex(Config.getProperty((String)"graphdb.auth.methods.x509.subject.dn.pattern", (String)"CN=(.*?)(?:,|$)"));
    }

    String getX509Username(HttpServletRequest request) {
        X509Certificate cert = this.extractClientCertificate(request);
        return cert != null ? this.principalExtractor.extractPrincipal(cert).toString() : null;
    }

    private X509Certificate extractClientCertificate(HttpServletRequest request) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("jakarta.servlet.request.X509Certificate");
        if (certs != null && certs.length > 0) {
            this.logger.debug("X.509 client authentication certificate:{}", (Object)certs[0]);
            return certs[0];
        }
        this.logger.debug("No client certificate found in request.");
        return null;
    }
}

