/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.http;

import com.ontotext.graphdb.http.HttpClientProvider;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public abstract class DefaultHttpClientProvider
implements HttpClientProvider {
    private volatile CloseableHttpClient httpClient;
    private AtomicBoolean initialized = new AtomicBoolean();

    public abstract boolean isTlsEnabled();

    @Override
    public CloseableHttpClient getHttpClient() {
        if (this.initialized.compareAndSet(false, true)) {
            this.httpClient = this.createHttpClient().build();
        }
        while (this.httpClient == null) {
            Thread.onSpinWait();
        }
        return this.httpClient;
    }

    protected HttpClientBuilder createHttpClient() {
        return HttpClientBuilder.create().useSystemProperties().setMaxConnPerRoute(10000).setMaxConnTotal(1000);
    }

    protected int getDefaultSocketSoTimeout() {
        return this.isTlsEnabled() ? (int)TimeUnit.HOURS.toMillis(5L) : 0;
    }
}

