/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.core.proxy;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URLEncodedUtils;

public class SkipParametersHttpServletRequest
extends HttpServletRequestWrapper {
    private final Set<String> paramsToSkip;

    public SkipParametersHttpServletRequest(HttpServletRequest request, Set<String> paramsToSkip) {
        super(request);
        this.paramsToSkip = paramsToSkip;
    }

    public Map<String, String[]> getParameterMap() {
        Map parameters = super.getParameterMap();
        return parameters.entrySet().stream().filter(o -> !this.paramsToSkip.contains(o.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public String getQueryString() {
        String originalQueryString = super.getQueryString();
        if (originalQueryString == null) {
            return null;
        }
        List params = URLEncodedUtils.parse((String)originalQueryString, (Charset)StandardCharsets.UTF_8);
        List filteredParams = params.stream().filter(param -> !this.paramsToSkip.contains(param.getName())).collect(Collectors.toList());
        return URLEncodedUtils.format(filteredParams, (Charset)StandardCharsets.UTF_8);
    }
}

