/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository.handler;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.common.lang.service.FileFormatServiceRegistry;
import org.eclipse.rdf4j.common.webapp.util.HttpServerUtil;
import org.eclipse.rdf4j.http.protocol.error.ErrorInfo;
import org.eclipse.rdf4j.http.protocol.error.ErrorType;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.HTTPException;
import org.eclipse.rdf4j.http.server.ProtocolUtil;
import org.eclipse.rdf4j.http.server.repository.BooleanQueryResultView;
import org.eclipse.rdf4j.http.server.repository.GraphQueryResultView;
import org.eclipse.rdf4j.http.server.repository.TupleQueryResultView;
import org.eclipse.rdf4j.http.server.repository.handler.AbstractQueryRequestHandler;
import org.eclipse.rdf4j.http.server.repository.resolver.RepositoryResolver;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.UnsupportedQueryLanguageException;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultWriterRegistry;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.View;

public class DefaultQueryRequestHandler
extends AbstractQueryRequestHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DefaultQueryRequestHandler(RepositoryResolver repositoryResolver) {
        super(repositoryResolver);
    }

    @Override
    protected Object evaluateQuery(Query query, long limit, long offset, boolean distinct) throws ClientHTTPException {
        if (query instanceof TupleQuery) {
            return this.evaluateQuery((TupleQuery)query, limit, offset, distinct);
        }
        if (query instanceof GraphQuery) {
            return this.evaluateQuery((GraphQuery)query, limit, offset, distinct);
        }
        if (query instanceof BooleanQuery) {
            return this.evaluateQuery((BooleanQuery)query, limit, offset, distinct);
        }
        throw new ClientHTTPException(400, "Unsupported query type: " + query.getClass().getName());
    }

    protected Boolean evaluateQuery(BooleanQuery query, long limit, long offset, boolean distinct) {
        return query.evaluate();
    }

    protected GraphQueryResult evaluateQuery(GraphQuery query, long limit, long offset, boolean distinct) {
        GraphQueryResult qqr = distinct ? QueryResults.distinctResults((GraphQueryResult)query.evaluate()) : query.evaluate();
        return QueryResults.limitResults((GraphQueryResult)qqr, (long)limit, (long)offset);
    }

    protected TupleQueryResult evaluateQuery(TupleQuery query, long limit, long offset, boolean distinct) {
        TupleQueryResult tqr = distinct ? QueryResults.distinctResults((TupleQueryResult)query.evaluate()) : query.evaluate();
        return QueryResults.limitResults((TupleQueryResult)tqr, (long)limit, (long)offset);
    }

    @Override
    protected View getViewFor(Query query) {
        if (query instanceof TupleQuery) {
            return TupleQueryResultView.getInstance();
        }
        if (query instanceof GraphQuery) {
            return GraphQueryResultView.getInstance();
        }
        if (query instanceof BooleanQuery) {
            return BooleanQueryResultView.getInstance();
        }
        return null;
    }

    @Override
    protected FileFormatServiceRegistry<? extends FileFormat, ?> getResultWriterFor(Query query) {
        if (query instanceof TupleQuery) {
            return TupleQueryResultWriterRegistry.getInstance();
        }
        if (query instanceof GraphQuery) {
            return RDFWriterRegistry.getInstance();
        }
        if (query instanceof BooleanQuery) {
            return BooleanQueryResultWriterRegistry.getInstance();
        }
        return null;
    }

    @Override
    protected String getQueryString(HttpServletRequest request, RequestMethod requestMethod) throws HTTPException {
        String queryString;
        if (requestMethod == RequestMethod.POST) {
            String mimeType;
            switch (mimeType = HttpServerUtil.getMIMEType(request.getContentType())) {
                case "application/sparql-query": {
                    try {
                        queryString = IOUtils.toString((Reader)request.getReader());
                        break;
                    }
                    catch (IOException e) {
                        throw new HTTPException(400, "Error reading request message body", e);
                    }
                }
                case "application/x-www-form-urlencoded": {
                    queryString = request.getParameter("query");
                    break;
                }
                default: {
                    throw new ClientHTTPException(415, "Unsupported MIME type: " + mimeType);
                }
            }
        } else {
            queryString = request.getParameter("query");
        }
        if (queryString == null) {
            throw new ClientHTTPException(400, "Missing parameter: query");
        }
        return queryString;
    }

    @Override
    protected Query getQuery(HttpServletRequest request, RepositoryConnection repositoryCon, String queryString) throws IOException, HTTPException {
        QueryLanguage queryLn = this.getQueryLanguage(request.getParameter("queryLn"));
        String baseIRI = request.getParameter("baseURI");
        try {
            Query query = repositoryCon.prepareQuery(queryLn, queryString, baseIRI);
            this.setQueryParameters(request, repositoryCon, query);
            return query;
        }
        catch (UnsupportedQueryLanguageException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.UNSUPPORTED_QUERY_LANGUAGE, queryLn.getName());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (MalformedQueryException e) {
            ErrorInfo errInfo = new ErrorInfo(ErrorType.MALFORMED_QUERY, e.getMessage());
            throw new ClientHTTPException(400, errInfo.toString());
        }
        catch (RepositoryException e) {
            this.logger.error("Repository error", (Throwable)e);
            throw new ClientHTTPException(500, e.getMessage());
        }
    }

    protected void setQueryParameters(HttpServletRequest request, RepositoryConnection repositoryCon, Query query) throws ClientHTTPException {
        SimpleDataset dataset;
        query.setIncludeInferred(this.getIncludeInferred(request));
        int maxExecutionTime = this.getMaxExecutionTime(request);
        if (maxExecutionTime > 0) {
            query.setMaxExecutionTime(maxExecutionTime);
        }
        if ((dataset = this.getDataset(request, repositoryCon.getValueFactory(), query)) != null) {
            query.setDataset((Dataset)dataset);
        }
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            if (!parameterName.startsWith("$") || parameterName.length() <= "$".length()) continue;
            String bindingName = parameterName.substring("$".length());
            Value bindingValue = ProtocolUtil.parseValueParam(request, parameterName, repositoryCon.getValueFactory());
            query.setBinding(bindingName, bindingValue);
        }
    }

    protected int getMaxExecutionTime(HttpServletRequest request) throws ClientHTTPException {
        return ProtocolUtil.parseTimeoutParam(request);
    }

    protected boolean getIncludeInferred(HttpServletRequest request) throws ClientHTTPException {
        return this.getParam(request, "infer", true, Boolean.TYPE);
    }

    protected SimpleDataset getDataset(HttpServletRequest request, ValueFactory valueFactory, Query query) throws ClientHTTPException {
        IRI iri;
        String[] defaultGraphIRIs = request.getParameterValues("default-graph-uri");
        String[] namedGraphIRIs = request.getParameterValues("named-graph-uri");
        if (defaultGraphIRIs == null && namedGraphIRIs == null) {
            return null;
        }
        SimpleDataset dataset = new SimpleDataset();
        if (defaultGraphIRIs != null) {
            for (String defaultGraphIRI : defaultGraphIRIs) {
                try {
                    iri = this.createIRIOrNull(valueFactory, defaultGraphIRI);
                    dataset.addDefaultGraph(iri);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Illegal IRI for default graph: " + defaultGraphIRI);
                }
            }
        }
        if (namedGraphIRIs != null) {
            for (String namedGraphIRI : namedGraphIRIs) {
                try {
                    iri = this.createIRIOrNull(valueFactory, namedGraphIRI);
                    dataset.addNamedGraph(iri);
                }
                catch (IllegalArgumentException e) {
                    throw new ClientHTTPException(400, "Illegal IRI for named graph: " + namedGraphIRI);
                }
            }
        }
        return dataset;
    }

    protected QueryLanguage getQueryLanguage(String queryLanguageParamName) throws ClientHTTPException {
        if (queryLanguageParamName != null) {
            this.logger.debug("query language param = {}", (Object)queryLanguageParamName);
            QueryLanguage queryLn = QueryLanguage.valueOf((String)queryLanguageParamName);
            if (queryLn == null) {
                throw new ClientHTTPException(400, "Unknown query language: " + queryLanguageParamName);
            }
            return queryLn;
        }
        return QueryLanguage.SPARQL;
    }

    private IRI createIRIOrNull(ValueFactory valueFactory, String graphIRI) {
        if ("null".equals(graphIRI)) {
            return null;
        }
        return valueFactory.createIRI(graphIRI);
    }
}

