/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server.repository;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.rdf4j.common.lang.FileFormat;
import org.eclipse.rdf4j.http.server.repository.QueryResultView;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQueryResultView
extends QueryResultView {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final GraphQueryResultView INSTANCE = new GraphQueryResultView();

    public static GraphQueryResultView getInstance() {
        return INSTANCE;
    }

    private GraphQueryResultView() {
    }

    public String getContentType() {
        return null;
    }

    @Override
    protected void renderInternal(Map model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        RDFWriterFactory rdfWriterFactory = (RDFWriterFactory)model.get("factory");
        RDFFormat rdfFormat = rdfWriterFactory.getRDFFormat();
        response.setStatus(200);
        this.setContentType(response, (FileFormat)rdfFormat);
        this.setContentDisposition(model, response, (FileFormat)rdfFormat);
        boolean headersOnly = (Boolean)model.get("headersOnly");
        if (!headersOnly) {
            try (ServletOutputStream out = response.getOutputStream();){
                try {
                    RDFWriter rdfWriter = rdfWriterFactory.getWriter((OutputStream)out);
                    GraphQueryResult graphQueryResult = (GraphQueryResult)model.get("queryResult");
                    QueryResults.report((GraphQueryResult)graphQueryResult, (RDFHandler)rdfWriter);
                }
                catch (QueryInterruptedException e) {
                    this.logger.error("Query interrupted", (Throwable)e);
                    response.sendError(503, "Query evaluation took too long");
                }
                catch (QueryEvaluationException e) {
                    this.logger.error("Query evaluation error", (Throwable)e);
                    response.sendError(500, "Query evaluation error: " + e.getMessage());
                }
                catch (RDFHandlerException e) {
                    this.logger.error("Serialization error", (Throwable)e);
                    response.sendError(500, "Serialization error: " + e.getMessage());
                }
            }
        }
        this.logEndOfRequest(request);
    }
}

