/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.slf4j.MDC;
import org.springframework.web.servlet.HandlerInterceptor;

public abstract class ServerInterceptor
implements HandlerInterceptor {
    private static final String REQUEST_ID_KEY = "org.eclipse.rdf4j.requestId";
    private static final String PROCESS_ID = "process:" + String.valueOf(UUID.randomUUID());
    private static final AtomicLong requestNumber = new AtomicLong(0L);
    private volatile String origThreadName;

    private static String createRequestId() {
        return PROCESS_ID + ":request:" + requestNumber.getAndIncrement();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.origThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.getThreadName());
        MDC.put((String)REQUEST_ID_KEY, (String)ServerInterceptor.createRequestId());
        this.setRequestAttributes(request);
        return super.preHandle(request, response, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
        try {
            this.cleanUpResources();
        }
        finally {
            MDC.remove((String)REQUEST_ID_KEY);
            Thread.currentThread().setName(this.origThreadName);
        }
    }

    protected abstract String getThreadName() throws ServerHTTPException;

    protected void setRequestAttributes(HttpServletRequest request) throws ClientHTTPException, ServerHTTPException {
    }

    protected void cleanUpResources() throws ServerHTTPException {
    }
}

