/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json.converters.unsigned;

import com.ontotext.rdf.transformer.graphql.json.converters.BaseNumberValueConverter;
import java.util.Objects;

abstract class BaseUnsignedValueConverter
extends BaseNumberValueConverter {
    BaseUnsignedValueConverter() {
    }

    protected String convertUnsigned(Object value, long maxValue) {
        Long convert = this.getAsLong(value);
        if (convert == null) {
            return null;
        }
        if (this.isUnsignedInRange(convert, maxValue)) {
            return Objects.toString(convert);
        }
        return null;
    }

    private boolean isUnsignedInRange(long value, long maxValue) {
        return 0L <= value && value <= maxValue;
    }

    protected String convertUnsignedStrict(Object value, long maxValue) {
        if (value == null) {
            return null;
        }
        Long longValue = this.getAsLong(value);
        if (longValue == null) {
            throw this.invalidValue(value);
        }
        this.checkUnsignedRange(longValue, maxValue);
        return Objects.toString(longValue);
    }

    private void checkUnsignedRange(long value, long maxValue) {
        if (!this.isUnsignedInRange(value, maxValue)) {
            throw this.outOfRange(value);
        }
    }
}

