/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json.converters;

import com.ontotext.rdf.transformer.graphql.json.converters.AbstractValueConverter;

public class BooleanValueConverter
extends AbstractValueConverter {
    @Override
    public Object convert(Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof String) {
            if ("true".equalsIgnoreCase(value.toString()) || "1".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value.toString()) || "0".equals(value)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public Object convertStrict(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof String) {
            if ("true".equalsIgnoreCase(value.toString()) || "1".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(value.toString()) || "0".equals(value)) {
                return Boolean.FALSE;
            }
        }
        throw this.invalidValue(value);
    }

    @Override
    public String getSupportedType() {
        return "Boolean";
    }
}

