/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json.converters;

import com.ontotext.models.ErrorMessages;
import com.ontotext.rdf.transformer.graphql.json.InvalidValueException;
import com.ontotext.rdf.transformer.graphql.json.converters.AbstractValueConverter;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class BaseNumberValueConverter
extends AbstractValueConverter {
    protected BigDecimal stringToBigDecimal(Object doubleValue) {
        Object value = doubleValue.toString();
        if (!((String)value).contains(".")) {
            value = (String)value + ".0";
        }
        try {
            return new BigDecimal((String)value);
        }
        catch (NumberFormatException nfe) {
            throw this.invalidValue(doubleValue);
        }
    }

    protected BigInteger toBigInteger(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof BigDecimal) {
            try {
                return ((BigDecimal)value).toBigIntegerExact();
            }
            catch (ArithmeticException ae) {
                throw this.invalidValue(value);
            }
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        if (value instanceof String) {
            BigDecimal decimal = this.stringToBigDecimal(value);
            try {
                return decimal.toBigIntegerExact();
            }
            catch (ArithmeticException nfe) {
                throw this.invalidValue(value);
            }
        }
        return null;
    }

    protected Long getAsLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof BigInteger) {
            return this.bigIntegerToLong((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            try {
                return this.bigIntegerToLong(((BigDecimal)value).toBigIntegerExact());
            }
            catch (ArithmeticException ae) {
                throw this.invalidValue(value);
            }
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return this.bigIntegerToLong(this.toBigInteger(value));
            }
            catch (NumberFormatException nfe) {
                throw this.invalidValue(value);
            }
        }
        return null;
    }

    protected Long bigIntegerToLong(BigInteger value) {
        try {
            return value.longValueExact();
        }
        catch (ArithmeticException ae) {
            throw this.outOfRange(value);
        }
    }

    protected void checkRange(BigInteger value, BigInteger minValue, BigInteger maxValue) {
        if (this.isNotInRange(value, minValue, maxValue)) {
            throw this.outOfRange(value);
        }
    }

    protected boolean isNotInRange(BigInteger value, BigInteger minValue, BigInteger maxValue) {
        return null != maxValue && value.compareTo(maxValue) > 0 || null != minValue && value.compareTo(minValue) < 0;
    }

    protected InvalidValueException outOfRange(Object value) {
        return new InvalidValueException(ErrorMessages.get((String)"outOfRange.value", (Object[])new Object[]{value, this.getSupportedType()}));
    }

    protected Object toLongInRange(Object value, BigInteger min, BigInteger max) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Number) && !(value instanceof String)) {
            throw this.invalidValue(value);
        }
        BigInteger integer = this.toBigInteger(value);
        this.checkRange(integer, min, max);
        return integer.longValue();
    }
}

