/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json;

import com.ontotext.rdf.transformer.graphql.json.InvalidValueException;

public interface ValueConverter {
    public Object convert(Object var1);

    public Object convertStrict(Object var1) throws InvalidValueException;

    public String getSupportedType();

    public static ValueConverter toRelaxedConverter(ValueConverter converter) {
        if (converter instanceof RelaxedValueConverter) {
            return converter;
        }
        if (converter instanceof StrictValueConverter) {
            return new RelaxedValueConverter(((StrictValueConverter)converter).delegate);
        }
        return new RelaxedValueConverter(converter);
    }

    public static ValueConverter toStrictConverter(ValueConverter converter) {
        if (converter instanceof StrictValueConverter) {
            return converter;
        }
        if (converter instanceof RelaxedValueConverter) {
            return new StrictValueConverter(((RelaxedValueConverter)converter).delegate);
        }
        return new StrictValueConverter(converter);
    }

    public static class RelaxedValueConverter
    implements ValueConverter {
        private final ValueConverter delegate;

        RelaxedValueConverter(ValueConverter delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object convert(Object value) {
            return this.delegate.convert(value);
        }

        @Override
        public Object convertStrict(Object value) {
            return this.delegate.convert(value);
        }

        @Override
        public String getSupportedType() {
            return this.delegate.getSupportedType();
        }

        public String toString() {
            return "Relaxed" + this.delegate.toString();
        }
    }

    public static class StrictValueConverter
    implements ValueConverter {
        private final ValueConverter delegate;

        StrictValueConverter(ValueConverter delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object convert(Object value) {
            return this.delegate.convertStrict(value);
        }

        @Override
        public Object convertStrict(Object value) {
            return this.delegate.convertStrict(value);
        }

        @Override
        public String getSupportedType() {
            return this.delegate.getSupportedType();
        }

        public String toString() {
            return "Strict" + this.delegate.toString();
        }
    }
}

