/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.query.LangFilter;
import com.ontotext.rdf.transformer.graphql.json.ResponseValueFilter;
import com.ontotext.soaas.common.rdf.LiteralValue;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class LangStringValueFilter
implements ResponseValueFilter {
    @Override
    public void filterValues(List<Object> values, Selectable selection) {
        LangFilter langFilter = this.getApplicableFilter(selection);
        if (langFilter == null) {
            return;
        }
        if (langFilter.isFetchAnyValue()) {
            if (!langFilter.isFetchAll()) {
                Object firstValue = values.get(0);
                values.clear();
                values.add(firstValue);
            }
            return;
        }
        LinkedHashSet<String> fetchedLangs = new LinkedHashSet<String>();
        for (Object value : values) {
            if (value instanceof LiteralValue) {
                fetchedLangs.add(((LiteralValue)value).getLangLowerCase());
                continue;
            }
            if (!(value instanceof String)) continue;
            fetchedLangs.add("");
        }
        Set allowedLangs = langFilter.filterLanguageTags(fetchedLangs).collect(Collectors.toCollection(LinkedHashSet::new));
        if (allowedLangs.isEmpty()) {
            values.clear();
            return;
        }
        if (langFilter.isFetchAll()) {
            values.removeIf(this.notAllowed(allowedLangs));
        } else {
            if (allowedLangs.size() == 1 && values.size() == 1) {
                return;
            }
            String preferredLang = (String)allowedLangs.iterator().next();
            Optional<Object> value = values.stream().filter(this.notAllowed(Collections.singleton(preferredLang)).negate()).findFirst();
            values.clear();
            value.ifPresent(values::add);
        }
    }

    private LangFilter getApplicableFilter(Selectable selection) {
        if (!"Literal".equals(selection.getType()) && !this.isAllowedToFilterName(selection)) {
            return null;
        }
        return selection.getArguments().getLangFilter().orElse(null);
    }

    private boolean isAllowedToFilterName(Selectable selection) {
        if (!selection.getName().equals("name")) {
            return false;
        }
        return selection.getProperty().filter(PropertyShape::isLiteral).isPresent();
    }

    private Predicate<Object> notAllowed(Set<String> allowedLangs) {
        return value -> {
            String lang = null;
            if (value instanceof LiteralValue) {
                lang = ((LiteralValue)value).getLangLowerCase();
            } else if (value instanceof String) {
                lang = "";
            }
            return lang == null || !allowedLangs.contains(lang);
        };
    }
}

