/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json;

import com.ontotext.models.PropertyShape;
import com.ontotext.rdf.transformer.SerializationResponse;
import com.ontotext.rdf.transformer.ValueSerializationMode;
import com.ontotext.rdf.transformer.ValueSerializer;
import com.ontotext.rdf.transformer.graphql.json.ValueConverter;
import com.ontotext.rdf.transformer.graphql.json.ValueConverterFactory;
import com.ontotext.soaas.common.rdf.ValueReader;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;

public class JsonValueSerializer
implements ValueSerializer {
    private final ValueSerializationMode serializationMode;
    private final ValueConverterFactory valueConverters;

    public JsonValueSerializer() {
        this(ValueSerializationMode.DEFAULT, new ValueConverterFactory());
    }

    public JsonValueSerializer(ValueSerializationMode serializationMode, ValueConverterFactory valueConverters) {
        this.serializationMode = serializationMode;
        this.valueConverters = valueConverters;
    }

    public ValueSerializationMode getSerializationMode() {
        return this.serializationMode;
    }

    public SerializationResponse serialize(PropertyShape property, Collection<Object> values, ValueReader valueReader) {
        SerializationResponse serializationResponse = new SerializationResponse();
        if (property != null) {
            if (property.isLiteral()) {
                this.parseAndAddCollect(values, arg_0 -> ((ValueReader)valueReader).readAsLiteral(arg_0), serializationResponse);
            } else if (property.isScalarType()) {
                String expectedType = JsonValueSerializer.getExpectedOutputType(property);
                ValueConverter converter = this.getConverter(expectedType);
                BiFunction mapper = ValueSerializer.convertAndCollectErrors((String)expectedType, converter::convert, arg_0 -> ((SerializationResponse)serializationResponse).addError(arg_0), (ValueReader)valueReader);
                int index = 0;
                for (Object value : values) {
                    serializationResponse.addValue(mapper.apply(index++, value));
                }
            } else {
                this.parseAndAddCollect(values, arg_0 -> ((ValueReader)valueReader).read(arg_0), serializationResponse);
            }
        } else {
            this.parseAndAddCollect(values, arg_0 -> ((ValueReader)valueReader).read(arg_0), serializationResponse);
        }
        return serializationResponse;
    }

    private void parseAndAddCollect(Collection<Object> values, UnaryOperator<Object> valueReader, SerializationResponse serializationResponse) {
        for (Object value : values) {
            serializationResponse.addValue(valueReader.apply(value));
        }
    }

    private static String getExpectedOutputType(PropertyShape property) {
        return Objects.toString(property.getScalarType().getGraphql(), property.getRange());
    }

    private ValueConverter getConverter(String expectedType) {
        return this.valueConverters.getConverter(expectedType);
    }
}

