/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.Operation;
import com.ontotext.models.Selectable;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.rdf.transformer.SerializationError;
import com.ontotext.rdf.transformer.TransformContext;
import com.ontotext.rdf.transformer.graphql.json.CompactErrorHandler;
import com.ontotext.rdf.transformer.graphql.json.DefaultErrorHandler;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.common.sparql.ExecutionError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class ErrorHandler {
    static final String TYPENAME = "__typename";
    static final String MESSAGE = "message";
    static final String PATH = "path";
    static final String LOCATIONS = "locations";
    private List<Map<String, Object>> errors = new LinkedList<Map<String, Object>>();
    private List<Map<String, Object>> warnings = new LinkedList<Map<String, Object>>();
    protected List<Boolean> dataValidation = new ArrayList<Boolean>();
    protected List<Boolean> queryValidation = new ArrayList<Boolean>();

    public static ErrorHandler create(List<TransformContext> transformContexts, Map<String, Object> options) {
        boolean compactErrorMessages;
        Set requestSettings = transformContexts.stream().map(ErrorHandler::getCompactErrorsConfig).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        if (requestSettings.isEmpty()) {
            Optional<SomlSchema> schema = transformContexts.stream().filter(ctx -> ctx.getOperation() != null).map(ctx -> ctx.getOperation().getSchema()).filter(Objects::nonNull).findFirst();
            if (schema.flatMap(soml -> soml.getConfig().shouldCompactMessages()).isEmpty()) {
                Object appLevelConfig = options.getOrDefault("compactErrorMessages", "false");
                compactErrorMessages = "true".equals(appLevelConfig.toString());
            } else {
                compactErrorMessages = schema.flatMap(soml -> soml.getConfig().shouldCompactMessages()).filter(Boolean::booleanValue).isPresent();
            }
        } else {
            compactErrorMessages = requestSettings.contains(Boolean.TRUE);
        }
        return compactErrorMessages ? new CompactErrorHandler() : new DefaultErrorHandler();
    }

    private static Optional<Boolean> getCompactErrorsConfig(TransformContext ctx) {
        if (ctx.getOperation() == null || ctx.getOperation().getArguments() == null) {
            return Optional.empty();
        }
        return ctx.getOperation().getArguments().shouldCompactErrors();
    }

    public boolean onOperationResponseBegin(TransformContext transformContext) {
        this.onNewOperation();
        return ErrorHandler.isOperationPossible(transformContext, this.queryValidation::add, this.dataValidation::add, this::onWarning, this::onError);
    }

    public void onNewOperation() {
        this.warnings.clear();
        this.errors.clear();
    }

    public void onRequiredFieldWithoutValueError(Selectable selection, Deque<Object> path) {
        ErrorHandler.addRequiredFieldWithoutValueError(this::onError, selection, path);
    }

    public void onSingleValueViolationError(int valuesSize, Selectable selection, Deque<Object> path) {
        ErrorHandler.addSingleValueViolationError(this::onError, valuesSize, selection, path);
    }

    public void onSerializationError(SerializationError error, Selectable selection, Deque<Object> path) {
        ErrorHandler.addSerializationError(this::onError, error, selection, path);
    }

    public void onProcessingError(Map<String, Object> error) {
        this.onError(error);
    }

    public void onError(Map<String, Object> error) {
        this.errors.add(error);
    }

    public void onWarning(Map<String, Object> warning) {
        this.warnings.add(warning);
    }

    public boolean areQueriesValid() {
        return this.queryValidation.stream().allMatch(Boolean.TRUE::equals);
    }

    public boolean hasAnyValidData() {
        return this.dataValidation.stream().reduce(Boolean::logicalOr).orElse(false);
    }

    static void addRequiredFieldWithoutValueError(Consumer<Map<String, Object>> errorsConsumer, Selectable selection, Deque<Object> path) {
        LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>(3);
        error.put(MESSAGE, ErrorHandler.getRequiredFieldMessage(selection));
        error.put(PATH, new ArrayList<Object>(path));
        ErrorHandler.appendErrorLocation(error, selection);
        errorsConsumer.accept(error);
    }

    private static String getRequiredFieldMessage(Selectable selection) {
        String responseName = selection.getResponseName();
        String definedIn = selection.getDefinedIn();
        return ErrorMessages.get((String)"graphql.missing.required.field", (Object[])new Object[]{definedIn, responseName});
    }

    private static void appendErrorLocation(Map<String, Object> error, Selectable selection) {
        SourceLocation location = selection.getLocation();
        if (location != null) {
            error.put(LOCATIONS, Collections.singletonList(location.toMap()));
        }
    }

    static void addSingleValueViolationError(Consumer<Map<String, Object>> errorsConsumer, int valuesSize, Selectable selection, Deque<Object> path) {
        LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>(3);
        error.put(MESSAGE, ErrorHandler.getSingleValueViolationMessage(valuesSize, selection, path));
        if (!selection.getName().equals(TYPENAME)) {
            error.put(PATH, new ArrayList<Object>(path));
        }
        ErrorHandler.appendErrorLocation(error, selection);
        errorsConsumer.accept(error);
    }

    private static String getSingleValueViolationMessage(int valuesSize, Selectable selection, Deque<Object> path) {
        String responseName = selection.getResponseName();
        String definedIn = selection.getDefinedIn();
        if (selection.getName().equals(TYPENAME)) {
            return ErrorMessages.get((String)"graphql.multipleValuesForSingleValuePropertyAt", (Object[])new Object[]{valuesSize, responseName, definedIn, path.stream().map(Object::toString).collect(Collectors.joining("/"))});
        }
        return ErrorMessages.get((String)"graphql.multipleValuesForSingleValueProperty", (Object[])new Object[]{valuesSize, responseName, definedIn});
    }

    static void addSerializationError(Consumer<Map<String, Object>> errorsConsumer, SerializationError error, Selectable selection, Deque<Object> path) {
        LinkedHashMap<String, Object> errorMap = new LinkedHashMap<String, Object>(3);
        errorMap.put(MESSAGE, error.getCause());
        ArrayList<Object> list = new ArrayList<Object>(path);
        if (selection.isCollection()) {
            list.add(error.getIndex());
        }
        errorMap.put(PATH, list);
        ErrorHandler.appendErrorLocation(errorMap, selection);
        errorsConsumer.accept(errorMap);
    }

    private static Stream<Map<String, Object>> reportOperationErrors(Operation query, List<Serializable> errors) {
        return ErrorHandler.reportOperationErrors(query, errors, true);
    }

    private static Stream<Map<String, Object>> reportOperationErrors(Operation query, List<Serializable> errors, boolean includePath) {
        List<String> path = query != null ? Collections.singletonList(query.getResponseName()) : null;
        return errors.stream().map(error -> {
            if (error instanceof Map) {
                return (Map)((Object)error);
            }
            String message = error instanceof ExecutionError ? ((ExecutionError)error).getMessage() : Objects.toString(error);
            LinkedHashMap<String, Object> errorMap = new LinkedHashMap<String, Object>(5);
            errorMap.put(MESSAGE, message);
            if (includePath && path != null) {
                errorMap.put(PATH, path);
            }
            return errorMap;
        });
    }

    public void logErrors(List<Map<String, Object>> errors) {
        if (Loggers.graphqlLogger().isWarnEnabled() && !errors.isEmpty()) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                String errorString = objectMapper.writeValueAsString(errors);
                Loggers.graphqlLogger().warn("Finishing request with errors: {}", (Object)errorString);
            }
            catch (JsonProcessingException jpe) {
                throw new IllegalStateException(jpe);
            }
        }
    }

    static boolean isOperationPossible(TransformContext transformContext, Consumer<Boolean> queryValidation, Consumer<Boolean> dataValidation, Consumer<Map<String, Object>> warningConsumer, Consumer<Map<String, Object>> errorConsumer) {
        List queryWarnings = transformContext.getWarnings();
        if (!queryWarnings.isEmpty()) {
            ErrorHandler.reportOperationErrors(transformContext.getOperation(), queryWarnings, false).forEach(warningConsumer);
        }
        List queryErrors = transformContext.getErrors();
        ErrorHandler.convertMessages(queryErrors, errorConsumer, transformContext);
        boolean isDataValid = transformContext.getData() != null;
        boolean hasOperation = transformContext.getOperation() != null;
        queryValidation.accept(hasOperation && transformContext.getOperation().isValid() || !queryWarnings.isEmpty() || hasOperation && isDataValid && !queryErrors.isEmpty());
        dataValidation.accept(isDataValid);
        if (!hasOperation) {
            return false;
        }
        return isDataValid;
    }

    private static void convertMessages(List<Serializable> messages, Consumer<Map<String, Object>> errorConsumer, TransformContext transformContext) {
        if (!messages.isEmpty()) {
            ErrorHandler.reportOperationErrors(transformContext.getOperation(), messages).forEach(errorConsumer);
        }
    }

    public List<Map<String, Object>> getErrors() {
        return this.errors;
    }

    public List<Map<String, Object>> getWarnings() {
        return this.warnings;
    }
}

