/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.rdf.transformer.graphql.json;

import com.ontotext.models.EnumValueDef;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.SomlSchema;
import com.ontotext.rdf.transformer.SerializationResponse;
import com.ontotext.rdf.transformer.ValueSerializationMode;
import com.ontotext.rdf.transformer.ValueSerializer;
import com.ontotext.rdf.transformer.graphql.json.InvalidValueException;
import com.ontotext.rdf.transformer.graphql.json.ValueConverter;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.common.rdf.ValueReader;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class EnumAwareValueSerializer
implements ValueSerializer {
    private final ValueSerializer delegate;
    private final Map<String, ValueConverter> enumConverters;

    public EnumAwareValueSerializer(SomlSchema schema, ValueSerializer delegate) {
        this.delegate = delegate;
        this.enumConverters = this.createConverters(schema);
    }

    private Map<String, ValueConverter> createConverters(SomlSchema schema) {
        return schema.getTypes().values().stream().filter(ScalarType::isEnum).map(EnumConverter::new).map(this.changeConverterMode()).collect(Collectors.toMap(ValueConverter::getSupportedType, Function.identity()));
    }

    private UnaryOperator<ValueConverter> changeConverterMode() {
        boolean isStrict = this.getSerializationMode() == ValueSerializationMode.STRICT;
        return isStrict ? ValueConverter::toStrictConverter : UnaryOperator.identity();
    }

    public ValueSerializationMode getSerializationMode() {
        return this.delegate.getSerializationMode();
    }

    public SerializationResponse serialize(PropertyShape property, Collection<Object> values, ValueReader valueReader) {
        SerializationResponse convertedValues = this.delegate.serialize(property, values, valueReader);
        if (property != null && property.isScalarType() && property.getScalarType().isEnum()) {
            ValueConverter converter = this.enumConverters.get(property.getScalarType().getGraphql());
            assert (converter != null);
            SerializationResponse response = new SerializationResponse();
            convertedValues.getErrors().forEach(arg_0 -> ((SerializationResponse)response).addError(arg_0));
            String expectedType = converter.getSupportedType();
            BiFunction mapper = ValueSerializer.convertAndCollectErrors((String)expectedType, converter::convert, arg_0 -> ((SerializationResponse)response).addError(arg_0), (ValueReader)valueReader);
            int index = 0;
            for (Object value : convertedValues.getValues()) {
                response.addValue(mapper.apply(index++, value));
            }
            return response;
        }
        return convertedValues;
    }

    private static class EnumConverter
    implements ValueConverter {
        private final Map<Object, String> mapping;
        private final ScalarType scalarType;

        EnumConverter(ScalarType scalarType) {
            this.mapping = scalarType.getValues().stream().collect(Collectors.toMap(EnumValueDef::getValue, EnumValueDef::getName));
            this.scalarType = scalarType;
        }

        @Override
        public Object convert(Object value) {
            String result = this.mapping.get(value);
            if (result == null) {
                Loggers.graphqlLogger().warn("Unknown enum value {} from enum {}", value, (Object)this.getSupportedType());
            }
            return result;
        }

        @Override
        public Object convertStrict(Object value) {
            String result = this.mapping.get(value);
            if (result == null) {
                throw new InvalidValueException(String.format("Unknown enum value %s from enum %s", value, this.getSupportedType()));
            }
            return result;
        }

        @Override
        public String getSupportedType() {
            return this.scalarType.getGraphql();
        }
    }
}

