/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.stateless;

import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.forest.security.stateless.AuthenticationExpiredException;
import com.ontotext.graphdb.security.TokenManager;
import com.ontotext.graphdb.security.TokenUser;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service
public class GDBTokenAuthenticationService {
    @Autowired
    private AccountsService accountService;

    public void addAuthentication(HttpServletResponse response, AuthenticatedUser authentication) {
        response.addHeader("Authorization", this.createTokenForUser((UserDetails)authentication));
    }

    public Authentication getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("Authorization");
        if (token == null) {
            token = request.getParameter("authToken");
        }
        if (token != null && (token = token.replace("Bearer ", "")).startsWith("GDB ")) {
            TokenUser user = TokenManager.getInstance().parseUserFromToken(token);
            if (user == null || user.isExpired()) {
                throw new AuthenticationExpiredException();
            }
            return this.accountService.loadUserByUsername(user.getUsername()).toAuthentication();
        }
        return null;
    }

    private String createTokenForUser(UserDetails user) {
        TokenUser tokenUser = new TokenUser();
        tokenUser.setUsername(user.getUsername());
        return TokenManager.getInstance().createTokenForUser(tokenUser);
    }
}

