/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.setup;

import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.util.ResourceUtils;
import com.ontotext.forest.persistence.PersistedConfig;
import com.ontotext.forest.persistence.UsersConfig;
import com.ontotext.forest.security.PasswordEncoderFactory;
import com.ontotext.forest.security.provider.local.LocalAccountsService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.parser.ParseException;

public class SetSecurity {
    private File path;
    private PersistedConfig persistedConfig;
    private UsersConfig usersConfig;
    private LocalAccountsService accountsService;
    private List<Command> commands = new ArrayList<Command>();

    private void init() {
        if (this.path == null) {
            this.path = ResourceUtils.initApplicationDir();
        }
        this.persistedConfig = PersistedConfig.fromDirectory((File)this.path);
        this.usersConfig = UsersConfig.fromDirectory((File)this.path, (PersistedConfig)this.persistedConfig);
        this.accountsService = new LocalAccountsService(this.usersConfig, PasswordEncoderFactory.createPasswordEncoder());
    }

    private void set() {
        for (Command cmd : this.commands) {
            cmd.execute();
        }
    }

    private void addEnableCommand(String argument) {
        this.commands.add(() -> this.persistedConfig.updateMapEntry("properties", String.class, "security.enabled", (Object)argument));
    }

    private void addPasswordCommand(String username, String password) {
        this.commands.add(() -> {
            Account account = this.accountsService.getAccount(username);
            if (account == null) {
                throw new RuntimeException("No such username: " + username);
            }
            account.setPassword(password);
            this.accountsService.editUserAccount(account, true);
        });
    }

    public static void main(String[] args) throws IOException, ParseException {
        if (args.length < 1) {
            SetSecurity.showUsageAndExit();
        }
        SetSecurity setSecurity = new SetSecurity();
        block10: for (String arg : args) {
            String[] argFields = arg.split(":", 2);
            if (argFields.length < 2) {
                SetSecurity.showUsageAndExit();
            }
            switch (argFields[0]) {
                case "config": {
                    setSecurity.path = new File(argFields[1]);
                    continue block10;
                }
                case "enable": {
                    if (!"true".equals(argFields[1]) && !"false".equals(argFields[1])) {
                        SetSecurity.showUsageAndExit();
                    }
                    setSecurity.addEnableCommand(argFields[1]);
                    continue block10;
                }
                case "password": {
                    String[] userPassword = argFields[1].split(":", 2);
                    if (userPassword.length < 2) {
                        SetSecurity.showUsageAndExit();
                    }
                    setSecurity.addPasswordCommand(userPassword[0], userPassword[1]);
                    continue block10;
                }
                default: {
                    SetSecurity.showUsageAndExit();
                }
            }
        }
        setSecurity.init();
        setSecurity.set();
    }

    private static void showUsageAndExit() {
        System.err.println("Usage: set-security <command> [<command>]");
        System.err.println("Possible commands:");
        System.err.println("  config:<path>  Sets the directory where settings.js is. The default is <data>/settings.js.");
        System.err.println("  enable:true  Enable security.");
        System.err.println("  enable:false  Disable security.");
        System.err.println("  password:<username>:<password>  Sets the password for <username> to <password>.");
        System.exit(1);
    }

    static interface Command {
        public void execute();
    }
}

