/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.local;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.persistence.UsersConfig;
import com.ontotext.forest.security.AuthenticatedUser;
import com.ontotext.forest.security.AuthenticationMethod;
import com.ontotext.forest.security.PasswordEncoderFactory;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.security.Role;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;

public class LocalAccountsService
implements AccountsService,
AuthenticationProvider,
AuthenticationMethod.Basic,
AuthenticationMethod.GDB,
AuthenticationMethod.X509,
AuthenticationMethod.Kerberos,
AuthenticationMethod.OpenId {
    public static final String PERSISTENCE_PROPERTY = "users";
    public static final String ADMIN_USERNAME = "admin";
    public static final String ADMIN_PASSWORD = "root";
    private static final String LEGACY_GPT_THREADS_PROPERTY = "gpt_threads";
    @Autowired
    private UsersConfig usersConfig;
    @Autowired
    private SecurityConfig securityConfig;
    private PasswordEncoder passwordEncoder;
    private DaoAuthenticationProvider authenticationProvider;
    private final boolean case_insensitive = Config.getPropertyAsBoolean((String)"graphdb.auth.database.case_insensitive", (boolean)false);

    public LocalAccountsService() {
        this.passwordEncoder = PasswordEncoderFactory.createPasswordEncoder();
    }

    public LocalAccountsService(UsersConfig usersConfig, PasswordEncoder passwordEncoder) {
        this.usersConfig = usersConfig;
        this.passwordEncoder = passwordEncoder;
        this.initCommon();
    }

    @PostConstruct
    public void init() {
        this.initCommon();
        if (this.securityConfig.isDirectPasswordAuthEnabled()) {
            this.authenticationProvider = new DaoAuthenticationProvider();
            this.authenticationProvider.setPasswordEncoder(this.passwordEncoder);
            this.authenticationProvider.setUserDetailsService((UserDetailsService)this);
        }
    }

    private void initCommon() {
        this.migrateOldGptThreads();
        Map<String, Account> users = this.getUsers();
        HashMap<String, Account> modified = new HashMap<String, Account>();
        for (Map.Entry<String, Account> entry : users.entrySet()) {
            Account account = entry.getValue();
            LinkedHashSet<String> modifiedAuthorities = new LinkedHashSet<String>();
            HashSet<String> roles = new HashSet<String>();
            for (String authority : account.getGrantedAuthorities()) {
                if (authority.startsWith("READ_REPO_") || authority.startsWith("WRITE_REPO_")) {
                    String[] parts = authority.split("_");
                    if (parts.length == 3) {
                        modifiedAuthorities.add(authority);
                        continue;
                    }
                    if (parts.length >= 4) {
                        if (parts[2].equals("") || parts[2].equals("*") || parts[2].startsWith("http://") || parts[2].startsWith("https://")) {
                            authority = Stream.iterate(0, i -> i + 1).limit(parts.length).filter(i -> i != 2).map(i -> parts[i]).collect(Collectors.joining("_"));
                        }
                        modifiedAuthorities.add(authority);
                        continue;
                    }
                    throw new IllegalStateException(authority);
                }
                if (authority.startsWith("CUSTOM_")) {
                    modifiedAuthorities.add(authority);
                    continue;
                }
                if (authority.equals("ROLE_REPO_ADMIN")) {
                    authority = Role.ROLE_REPO_MANAGER.name();
                }
                if (authority.equals(Role.ROLE_ADMIN.name()) || authority.equals(Role.ROLE_REPO_MANAGER.name()) || authority.equals(Role.ROLE_USER.name())) {
                    roles.add(authority);
                    continue;
                }
                try {
                    modifiedAuthorities.add(Role.valueOf((String)authority).name());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (roles.contains(Role.ROLE_ADMIN.name())) {
                modifiedAuthorities.add(Role.ROLE_ADMIN.name());
            } else if (roles.contains(Role.ROLE_REPO_MANAGER.name())) {
                modifiedAuthorities.add(Role.ROLE_REPO_MANAGER.name());
            } else {
                modifiedAuthorities.add(Role.ROLE_USER.name());
            }
            account.setGrantedAuthorities(modifiedAuthorities);
            modified.put(entry.getKey(), entry.getValue());
        }
        users.putAll(modified);
        this.saveUsers(users);
        Account user = users.get(ADMIN_USERNAME);
        if (user == null) {
            this.initAdminUser();
        }
    }

    private void migrateOldGptThreads() {
        Map<String, Account> users = this.getUsers();
        HashMap<String, Account> modified = new HashMap<String, Account>();
        for (Map.Entry<String, Account> user : users.entrySet()) {
            try {
                Set userChats = (Set)this.usersConfig.getMap(LEGACY_GPT_THREADS_PROPERTY, Set.class).get(user.getKey());
                if (userChats != null) {
                    Account account = user.getValue();
                    account.setGptThreads(userChats);
                    modified.put(user.getKey(), account);
                    this.usersConfig.deleteMapEntry(LEGACY_GPT_THREADS_PROPERTY, Set.class, user.getKey());
                }
            }
            catch (Exception userChats) {
                // empty catch block
            }
            try {
                List chats = (List)((Map)this.usersConfig.getMap(LEGACY_GPT_THREADS_PROPERTY, Map.class).get(user.getKey())).get(user.getKey());
                Set userChats = chats.stream().collect(Collectors.toSet());
                if (userChats == null) continue;
                Account account = user.getValue();
                account.setGptThreads(userChats);
                modified.put(user.getKey(), account);
                this.usersConfig.deleteMapEntry(LEGACY_GPT_THREADS_PROPERTY, Map.class, user.getKey());
            }
            catch (Exception exception) {}
        }
        this.saveUsers(modified);
    }

    private void initAdminUser() {
        Account adminUser = new Account();
        adminUser.setUsername(ADMIN_USERNAME);
        adminUser.setPassword(ADMIN_PASSWORD);
        ArrayList<String> authorities = new ArrayList<String>();
        authorities.add(Role.ROLE_ADMIN.name());
        adminUser.setGrantedAuthorities(authorities);
        adminUser.setAppSettings(this.getDefaultSettings());
        this.addNewUser(adminUser);
    }

    private Map<String, Account> getUsers() {
        return this.usersConfig.getMap(PERSISTENCE_PROPERTY, Account.class);
    }

    private void saveUsers(Map<String, Account> users) {
        this.usersConfig.updateMapEntries(PERSISTENCE_PROPERTY, Account.class, users);
    }

    public synchronized void editUserAccount(Account user, boolean updatePassword) {
        Account userFromDB = this.getAccountOrThrow(user.getUsername());
        userFromDB.setAppSettings(user.getAppSettings());
        if (user.getGrantedAuthorities() != null) {
            userFromDB.setGrantedAuthorities(user.getGrantedAuthorities());
        }
        if (user.getGptThreads() != null) {
            userFromDB.setGptThreads(user.getGptThreads());
        }
        if (updatePassword) {
            this.setUserPassword(userFromDB, user.getPassword());
        }
        this.saveUser(userFromDB);
    }

    @VisibleForTesting
    public void saveUser(Account userFromDB) {
        String username = this.case_insensitive ? userFromDB.getUsername().toLowerCase(Locale.ROOT) : userFromDB.getUsername();
        Map<String, Account> users = this.getUsers();
        users.put(username, userFromDB);
        this.saveUsers(users);
    }

    public synchronized void addNewUser(Account user) {
        this.setUserPassword(user, user.getPassword());
        this.saveUser(user);
    }

    private void setUserPassword(Account user, String password) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            user.setPassword("*");
        } else {
            user.setPassword(this.passwordEncoder.encode((CharSequence)password));
        }
    }

    public synchronized void delete(String username) {
        if (ADMIN_USERNAME.equals(username)) {
            throw new IllegalStateException("Deleting the default admin user is not allowed!");
        }
        Account user = this.getAccountOrThrow(username);
        this.usersConfig.deleteMapEntry(PERSISTENCE_PROPERTY, Account.class, this.case_insensitive ? user.getUsername().toLowerCase(Locale.ROOT) : user.getUsername());
    }

    public Collection<Account> getAll() {
        return this.getUsers().values();
    }

    @Nullable
    public synchronized Account getAccount(String username) {
        Account account = this.getUsers().get(this.case_insensitive ? username.toLowerCase(Locale.ROOT) : username);
        if (account != null && account.getAppSettings() == null) {
            account.setAppSettings(this.getDefaultSettings());
            this.saveUser(account);
        }
        return account;
    }

    public Account getDefaultAdminAccount() {
        return this.getAccount(ADMIN_USERNAME);
    }

    public boolean isLocal() {
        return true;
    }

    public AuthenticatedUser loadUserByUsername(String username, Collection<GrantedAuthority> authorities) {
        if (authorities != null) {
            throw new IllegalArgumentException("Overriding authorities not supported");
        }
        Account account = this.getAccountOrThrow(username);
        return new AuthenticatedUser(account.getUsername(), account.getPassword(), (Collection)account.getGrantedAuthorities().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList()), false, account.getAppSettings());
    }

    public String getImplementationName() {
        return "Local";
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username;
        Account account;
        if (authentication instanceof UsernamePasswordAuthenticationToken && (account = this.getAccount(username = authentication.getPrincipal().toString())) != null && !account.getPassword().startsWith("{")) {
            String password = authentication.getCredentials().toString() + "{" + username + "}";
            authentication = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        }
        return this.authenticationProvider.authenticate(authentication);
    }

    public boolean supports(Class<?> authentication) {
        return this.authenticationProvider.supports(authentication);
    }

    public AuthenticationProvider getAuthenticationProvider() {
        if (this.securityConfig.isDirectPasswordAuthEnabled()) {
            return this;
        }
        return null;
    }
}

