/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.provider.ldap;

import com.ontotext.forest.security.provider.ldap.LdapAccountsService;
import com.ontotext.forest.security.provider.ldap.LdapConfig;
import com.ontotext.forest.security.provider.ldap.LdapDirectGrantedAuthority;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.security.Role;
import java.util.HashSet;
import java.util.Set;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;

public class RepositoryLdapAuthoritiesPopulator
extends DefaultLdapAuthoritiesPopulator {
    private boolean hasReadFromLdap;
    private String readFromLdapBase;
    private String readFromLdapFilter;
    private String readFromLdapAttribute;
    private boolean hasWriteFromLdap;
    private String writeFromLdapBase;
    private String writeFromLdapFilter;
    private String writeFromLdapAttribute;
    private boolean hasRoleGraphDBFromLdap;
    private String roleGraphDBFromLdapBase;
    private String roleGraphDBFromLdapFilter;
    private String roleGraphDBFromLdapAttribute;

    public RepositoryLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        super(contextSource, groupSearchBase);
        this.setGroupSearchFilter(LdapConfig.getPropertyOrThrow("graphdb.auth.ldap.role.search.filter"));
        this.setRolePrefix("");
        this.setConvertToUpperCase(false);
        this.setGroupRoleAttribute(Config.getProperty((String)"graphdb.auth.ldap.role.search.attribute", (String)"cn"));
        this.setSearchSubtree(Config.getPropertyAsBoolean((String)"graphdb.auth.ldap.role.search.subtree", (boolean)true));
        this.readFromLdapFilter = Config.getProperty((String)"graphdb.auth.ldap.repository.read.filter");
        if (this.readFromLdapFilter != null) {
            this.readFromLdapBase = Config.getProperty((String)"graphdb.auth.ldap.repository.read.base", (String)"");
            this.readFromLdapAttribute = Config.getProperty((String)"graphdb.auth.ldap.repository.read.attribute", (String)"cn");
            this.hasReadFromLdap = true;
        }
        this.writeFromLdapFilter = Config.getProperty((String)"graphdb.auth.ldap.repository.write.filter");
        if (this.writeFromLdapFilter != null) {
            this.writeFromLdapBase = Config.getProperty((String)"graphdb.auth.ldap.repository.write.base", (String)"");
            this.writeFromLdapAttribute = Config.getProperty((String)"graphdb.auth.ldap.repository.write.attribute", (String)"cn");
            this.hasWriteFromLdap = true;
        }
        this.roleGraphDBFromLdapFilter = Config.getProperty((String)"graphdb.auth.ldap.role.graphdb.filter");
        if (this.roleGraphDBFromLdapFilter != null) {
            this.roleGraphDBFromLdapBase = Config.getProperty((String)"graphdb.auth.ldap.role.graphdb.base", (String)"");
            this.roleGraphDBFromLdapAttribute = Config.getProperty((String)"graphdb.auth.ldap.role.graphdb.attribute", (String)"cn");
            this.hasRoleGraphDBFromLdap = true;
        }
    }

    protected Set<GrantedAuthority> getAdditionalRoles(DirContextOperations user, String username) {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        String userDn = user.getNameInNamespace();
        if (this.hasWriteFromLdap) {
            Set writeRepositories = this.getLdapTemplate().searchForSingleAttributeValues(this.writeFromLdapBase, this.writeFromLdapFilter, (Object[])new String[]{userDn, username}, this.writeFromLdapAttribute);
            writeRepositories.forEach(r -> {
                authorities.add(new LdapDirectGrantedAuthority(Role.Repo.readForRepo((String)r)));
                authorities.add(new LdapDirectGrantedAuthority(Role.Repo.writeForRepo((String)r)));
            });
        }
        if (this.hasReadFromLdap) {
            Set readRepositories = this.getLdapTemplate().searchForSingleAttributeValues(this.readFromLdapBase, this.readFromLdapFilter, (Object[])new String[]{userDn, username}, this.readFromLdapAttribute);
            readRepositories.forEach(r -> authorities.add(new LdapDirectGrantedAuthority(Role.Repo.readForRepo((String)r))));
        }
        if (this.hasRoleGraphDBFromLdap) {
            Set graphDbRoles = this.getLdapTemplate().searchForSingleAttributeValues(this.roleGraphDBFromLdapBase, this.roleGraphDBFromLdapFilter, (Object[])new String[]{userDn, username}, this.roleGraphDBFromLdapAttribute);
            HashSet writeRepos = new HashSet();
            HashSet readRepos = new HashSet();
            graphDbRoles.forEach(r -> {
                String role = LdapConfig.normalizeRole(r);
                if (role != null) {
                    if (role.startsWith("READ_REPO_")) {
                        readRepos.add(role.substring("READ_REPO_".length()));
                    } else if (role.startsWith("WRITE_REPO_")) {
                        writeRepos.add(role.substring("WRITE_REPO_".length()));
                    }
                    authorities.add(new LdapDirectGrantedAuthority(role));
                } else {
                    LdapAccountsService.LOGGER.warn("Invalid direct GraphDB role from LDAP for user '{}': {}", (Object)username, r);
                }
            });
            writeRepos.forEach(repo -> {
                if (!readRepos.contains(repo)) {
                    authorities.add(new LdapDirectGrantedAuthority(Role.Repo.readForRepo((String)repo)));
                }
            });
        }
        return authorities;
    }
}

