/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.audit;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.security.audit.CachedRequestWrapper;
import com.ontotext.forest.security.audit.UUIDType5;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.security.Role;
import common.GraphDBMDCExecutorBuilder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.HexDump;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.StringUtils;

public class AuditUtils {
    private static final String ROLE_PREFIX = "ROLE_";
    private static final String OPERATION_SUFFIX = "_REPO";
    private static final String DENY_ALL_ROLE = "denyAll()";
    private static String GRAPHDB_AUDIT_ROLE;
    private static boolean GRAPHDB_AUDIT_ANY_ROLE;
    private static String GRAPHDB_AUDIT_REPOSITORY;
    private static Set<String> GRAPHDB_AUDIT_HEADERS;
    private static Set<String> REQUEST_ID_HEADERS;
    private static final String X_REQUEST_ID = "X-Request-Id";
    private static int MAX_CACHED_SIZE;
    private static boolean AUDIT_IS_ENABLED;

    public static void resetConfig() {
        String roleFromConfig = Config.getProperty((String)"graphdb.audit.role", (String)"").toUpperCase();
        if (roleFromConfig.equals("ANY")) {
            GRAPHDB_AUDIT_ANY_ROLE = true;
        } else {
            GRAPHDB_AUDIT_ROLE = !StringUtils.isEmpty((Object)roleFromConfig) ? ROLE_PREFIX + roleFromConfig : "";
        }
        String operationFromConfig = Config.getProperty((String)"graphdb.audit.repository", (String)"").toUpperCase();
        GRAPHDB_AUDIT_REPOSITORY = !StringUtils.isEmpty((Object)operationFromConfig) ? operationFromConfig + OPERATION_SUFFIX : "";
        GRAPHDB_AUDIT_HEADERS = Stream.of(Config.getProperty((String)"graphdb.audit.headers", (String)"").split("\\s*,\\s*")).filter(StringUtils::hasLength).collect(Collectors.toSet());
        AUDIT_IS_ENABLED = GRAPHDB_AUDIT_ANY_ROLE || !GRAPHDB_AUDIT_ROLE.isEmpty() || !GRAPHDB_AUDIT_REPOSITORY.isEmpty();
        MAX_CACHED_SIZE = NumberUtils.toInt((String)Config.getProperty((String)"graphdb.audit.request.max.length"), (int)1024);
        REQUEST_ID_HEADERS = Stream.of(Config.getProperty((String)"graphdb.request.id.alternatives", (String)"").toLowerCase().split("\\s*,\\s*")).filter(StringUtils::hasLength).collect(Collectors.toSet());
    }

    public static boolean shouldAuditOperation(String operation) {
        return !StringUtils.isEmpty((Object)GRAPHDB_AUDIT_REPOSITORY) && ("READ_REPO".equals(GRAPHDB_AUDIT_REPOSITORY) || "WRITE_REPO".equals(operation));
    }

    public static boolean shouldAuditRole(String role) {
        return AuditUtils.shouldAuditAnyRole() || DENY_ALL_ROLE.equals(role) || Role.shouldAuditRole((String)GRAPHDB_AUDIT_ROLE, (String)role);
    }

    public static boolean shouldAuditAnyRole() {
        return GRAPHDB_AUDIT_ANY_ROLE;
    }

    static void appendRequestHeaders(StringBuilder sb, HttpServletRequest request) {
        if (!GRAPHDB_AUDIT_HEADERS.isEmpty()) {
            StringBuilder tmpBuilder = new StringBuilder();
            GRAPHDB_AUDIT_HEADERS.forEach(headerName -> {
                String headerValue = request.getHeader(headerName);
                if (headerValue != null) {
                    tmpBuilder.append("\n\t").append((String)headerName).append(": ").append(request.getHeader(headerName));
                }
            });
            if (tmpBuilder.length() > 0) {
                sb.append("\nRequest headers:");
                sb.append((CharSequence)tmpBuilder);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void appendRequestBody(StringBuilder sb, HttpServletRequest request, HttpServletResponse response) throws IOException {
        int overflownAt;
        byte[] bodyBytes;
        CachedRequestWrapper cachedRequest = (CachedRequestWrapper)((Object)request.getAttribute("cached"));
        if (cachedRequest != null) {
            bodyBytes = cachedRequest.getContentAsByteArray();
            if (bodyBytes.length < MAX_CACHED_SIZE && response.getStatus() > 299) {
                try {
                    inputStream = cachedRequest.getInputStream();
                    if (!inputStream.isFinished()) {
                        IOUtils.skip((InputStream)inputStream, (long)MAX_CACHED_SIZE);
                        bodyBytes = cachedRequest.getContentAsByteArray();
                    }
                }
                catch (IOException inputStream) {
                    // empty catch block
                }
            }
            overflownAt = cachedRequest.getOverflownAt();
        } else {
            if (response.getStatus() != 401 && response.getStatus() != 403 && response.getStatus() != 409) return;
            overflownAt = 0;
            bodyBytes = new byte[MAX_CACHED_SIZE];
            try {
                inputStream = request.getInputStream();
                int read = IOUtils.read((InputStream)inputStream, (byte[])bodyBytes);
                if (read == 0) {
                    return;
                }
                if (read == MAX_CACHED_SIZE) {
                    overflownAt = MAX_CACHED_SIZE;
                }
            }
            catch (IOException e) {
                return;
            }
        }
        if (bodyBytes.length <= 0) return;
        String charset = request.getCharacterEncoding();
        CharBuffer charBuffer = null;
        if (charset != null) {
            try {
                charBuffer = Charset.forName(charset).newDecoder().decode(ByteBuffer.wrap(bodyBytes));
            }
            catch (IllegalArgumentException | MalformedInputException | UnmappableCharacterException exception) {
                // empty catch block
            }
        }
        if (charBuffer != null) {
            if ((request.getRequestURI().startsWith("/rest/security/users") || request.getRequestURI().startsWith("/rest/login")) && overflownAt == 0) {
                JSONObject body;
                sb.append("\nRequest body:\n");
                try {
                    body = (JSONObject)new JSONParser().parse(charBuffer.toString());
                }
                catch (ParseException e) {
                    sb.append("Malformed json.");
                    return;
                }
                body.replace((Object)"password", (Object)"<REDACTED>");
                sb.append(body);
                return;
            }
            AuditUtils.hasOverflown(overflownAt, sb);
            sb.append(charBuffer);
            return;
        }
        AuditUtils.hasOverflown(overflownAt, sb);
        sb.append("Hex dump:\n");
        AuditUtils.appendAsHexDump(sb, bodyBytes);
    }

    static void hasOverflown(int overflownAt, StringBuilder sb) {
        if (overflownAt == 0) {
            sb.append("\nRequest body:\n");
        } else {
            sb.append("\nRequest body (first ").append(overflownAt).append(" bytes):\n");
        }
    }

    @VisibleForTesting
    static void appendAsHexDump(final StringBuilder sb, byte[] bytes) throws IOException {
        try (OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                sb.append((char)b);
            }
        };){
            HexDump.dump((byte[])bytes, (long)0L, (OutputStream)out, (int)0);
        }
    }

    static boolean shouldCacheRequest(HttpServletRequest request) {
        return AuditUtils.shouldAuditRequest(request) && ("POST".equals(request.getMethod()) || "PUT".equals(request.getMethod()) || "PATCH".equals(request.getMethod()));
    }

    static boolean shouldAuditRequest(HttpServletRequest request) {
        return AuditUtils.isAuditEnabled() && (request.getAttribute("do_audit") != null || request.getRequestURI().startsWith("/rest/login"));
    }

    public static int getMaxCachedSize() {
        return MAX_CACHED_SIZE;
    }

    private static boolean isAuditEnabled() {
        return AUDIT_IS_ENABLED;
    }

    public static void markRequestForAudit(HttpServletRequest request) {
        request.setAttribute("do_audit", (Object)true);
        request.setAttribute("audit_username", (Object)AuditUtils.getAuthenticatedUsername());
    }

    public static String getAuditUsername(HttpServletRequest request) {
        String username = (String)request.getAttribute("audit_username");
        return username != null ? username : "unauthenticated";
    }

    private static String getAuthenticatedUsername() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            return authentication.getName();
        }
        return "unauthenticated";
    }

    public static void appendXRequestIdHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (GraphDBMDCExecutorBuilder.APPEND_REQUEST_ID_HEADERS) {
            String requestIdFromHeader;
            StringBuilder tmpBuilder = new StringBuilder();
            if (!REQUEST_ID_HEADERS.isEmpty()) {
                REQUEST_ID_HEADERS.forEach(headerName -> {
                    String headerValue = request.getHeader(headerName);
                    if (headerValue != null) {
                        tmpBuilder.append(" ").append((String)headerName).append(": ").append(headerValue);
                        response.addHeader(headerName, headerValue);
                    }
                });
            }
            if ((requestIdFromHeader = request.getHeader(X_REQUEST_ID)) != null && !REQUEST_ID_HEADERS.contains(X_REQUEST_ID.toLowerCase())) {
                tmpBuilder.append(" ").append(X_REQUEST_ID).append(": ").append(requestIdFromHeader);
                response.addHeader(X_REQUEST_ID, requestIdFromHeader);
            } else if (REQUEST_ID_HEADERS.isEmpty() || !REQUEST_ID_HEADERS.contains(X_REQUEST_ID.toLowerCase())) {
                String generatedXRequestId = UUIDType5.nameUUIDFromNamespaceAndString(UUID.randomUUID(), request.getRemoteAddr()).toString();
                tmpBuilder.append(" ").append(X_REQUEST_ID).append(": ").append(generatedXRequestId);
                response.addHeader(X_REQUEST_ID, generatedXRequestId);
            }
            if (tmpBuilder.length() > 0) {
                MDC.put((String)"headers", (String)tmpBuilder.toString());
            }
        }
    }

    static {
        AuditUtils.resetConfig();
    }
}

