/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security.audit;

import com.ontotext.forest.security.audit.AuditUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuditLoggingFilter
extends OncePerRequestFilter {
    private static Logger LOG = LoggerFactory.getLogger(AuditLoggingFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (AuditUtils.shouldAuditRequest(request)) {
            StringBuilder sb = new StringBuilder();
            sb.append(AuditUtils.getAuditUsername(request));
            sb.append(" | ").append(request.getRemoteAddr());
            sb.append(" | ").append(response.getStatus());
            sb.append(" | ").append(request.getMethod()).append(" ").append(request.getRequestURL());
            String graphDBRepository = request.getHeader("X-GraphDB-Repository");
            sb.append(" | ").append(graphDBRepository != null ? graphDBRepository : "-");
            AuditUtils.appendRequestHeaders(sb, request);
            AuditUtils.appendRequestBody(sb, request, response);
            LOG.info(sb.toString());
        }
    }
}

