/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.ontotext.forest.security.CachingDelegatingPasswordEncoder;
import com.ontotext.forest.security.OneTimePasswordEncoder;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.MessageDigestPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

public class PasswordEncoderFactory {
    private static final String ENCODING_ID = "bcrypt";
    private static final String ENCODED_PASS_PREFIX = "{bcrypt}$";

    public static PasswordEncoder createPasswordEncoder() {
        String encodingId = ENCODING_ID;
        HashMap<String, PasswordEncoder> encoders = new HashMap<String, PasswordEncoder>();
        encoders.put(encodingId, (PasswordEncoder)new BCryptPasswordEncoder());
        MessageDigestPasswordEncoder legacyEncoder = new MessageDigestPasswordEncoder("SHA-256");
        CachingDelegatingPasswordEncoder passwordEncoder = new CachingDelegatingPasswordEncoder(encodingId, encoders);
        passwordEncoder.setDefaultPasswordEncoderForMatches((PasswordEncoder)legacyEncoder);
        return new OneTimePasswordEncoder((PasswordEncoder)passwordEncoder);
    }

    public static boolean isPasswordEncoded(CharSequence password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return false;
        }
        if (password.length() < ENCODED_PASS_PREFIX.length()) {
            return false;
        }
        for (int i = 0; i < ENCODED_PASS_PREFIX.length(); ++i) {
            if (ENCODED_PASS_PREFIX.charAt(i) == password.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

