/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.ontotext.forest.security.audit.AuditUtils;
import com.ontotext.graphdb.security.Role;
import java.util.Collection;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;

public class HierarchicalRoleVoter
extends RoleVoter {
    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        if (authentication == null) {
            return -1;
        }
        int result = 0;
        Collection authorities = authentication.getAuthorities();
        FilterInvocation invocation = (FilterInvocation)object;
        boolean shouldAudit = false;
        block0: for (ConfigAttribute attribute : attributes) {
            if (!this.supports(attribute)) continue;
            result = -1;
            shouldAudit |= AuditUtils.shouldAuditRole(attribute.getAttribute());
            for (GrantedAuthority authority : authorities) {
                if (!Role.matches((String)authority.getAuthority(), (String)attribute.getAttribute())) continue;
                result = 1;
                break block0;
            }
        }
        if (shouldAudit) {
            AuditUtils.markRequestForAudit(invocation.getRequest());
        }
        return result;
    }

    public boolean supports(ConfigAttribute attribute) {
        return super.supports(attribute) || attribute.getAttribute().equals("denyAll()");
    }
}

