/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.security;

import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.security.KerberosAuthenticationProviderFactory;
import com.ontotext.forest.security.PreAuthenticatedAuthenticationProviderFactory;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.forest.security.provider.openid.OpenIdAuthenticationProvider;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.stereotype.Service;

@Service
public class AuthenticationManagerFactory {
    @Autowired
    private AccountsService accountsService;
    @Autowired
    private SecurityConfig securityConfig;
    @Autowired
    private ApplicationContext applicationContext;
    private final List<AuthenticationProvider> authenticationProviders = new ArrayList<AuthenticationProvider>(4);
    private OpenIdAuthenticationProvider openIdAuthenticationProvider;

    @PostConstruct
    public void init() throws Exception {
        AuthenticationProvider accountsServiceAuthenticationProvider = this.accountsService.getAuthenticationProvider();
        if (accountsServiceAuthenticationProvider != null) {
            this.authenticationProviders.add(accountsServiceAuthenticationProvider);
        }
        if (this.securityConfig.isKerberosAuthEnabled()) {
            this.authenticationProviders.add((AuthenticationProvider)KerberosAuthenticationProviderFactory.createAuthenticationProvider(this.accountsService));
        }
        if (this.securityConfig.isOpenIdAuthEnabled()) {
            OpenIdAuthenticationProvider openIdAuthenticationProvider = (OpenIdAuthenticationProvider)this.applicationContext.getAutowireCapableBeanFactory().createBean(OpenIdAuthenticationProvider.class);
            this.authenticationProviders.add(openIdAuthenticationProvider);
            this.openIdAuthenticationProvider = openIdAuthenticationProvider;
        }
        if (this.securityConfig.isX509AuthEnabled()) {
            this.authenticationProviders.add((AuthenticationProvider)PreAuthenticatedAuthenticationProviderFactory.createPreAuthenticationProvider(this.accountsService));
        }
    }

    public AuthenticationManager createAuthenticationManager() throws Exception {
        return new ProviderManager(this.authenticationProviders);
    }

    public OpenIdAuthenticationProvider getOpenIdAuthenticationProvider() {
        return this.openIdAuthenticationProvider;
    }
}

