/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.model;

import com.ontotext.rio.parallel.ParallelRDFInserter;
import com.ontotext.trree.OwlimConnection;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.PredicateIterator;
import com.ontotext.trree.RepositoryMonitorNotifiable;
import com.ontotext.trree.RepositoryMonitorTrackRecordHelper;
import com.ontotext.trree.RepositoryMonitorTrackRecordHelperSE;
import com.ontotext.trree.RepositoryMonitorTrackRecordImpl;
import com.ontotext.trree.entitypool.EntityPoolConnection;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.Statements;
import com.ontotext.trree.sdk.impl.StatementsImpl;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.slf4j.Logger;

public class TemporaryGraph
implements Closeable {
    private final String ruleset;
    private final Logger logger;
    private File directory;
    private OwlimSchemaRepository repository;
    private OwlimConnection owlimConnection;
    private StatementsImpl statements;
    private ParallelRDFInserter parallelInserter;
    private final AtomicBoolean initialised;
    private final AtomicBoolean softBegin;

    public TemporaryGraph(String ruleset, Logger logger) {
        this.ruleset = ruleset;
        this.logger = logger;
        this.initialised = new AtomicBoolean();
        this.softBegin = new AtomicBoolean();
    }

    private void init() throws IOException {
        if (this.initialised.compareAndSet(false, true)) {
            this.directory = Files.createTempDirectory("graphdb-tmp-graph", new FileAttribute[0]).toFile();
            this.repository = new OwlimSchemaRepository();
            this.repository.setDataDir(this.directory);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("ruleset", this.ruleset);
            if (this.ruleset.startsWith("owl")) {
                parameters.put("disable-sameAs", "false");
            } else {
                parameters.put("disable-sameAs", "true");
            }
            parameters.put("skip-default-plugins", "true");
            parameters.put("register-external-plugins", "");
            this.repository.setParameters(parameters);
            this.repository.init();
        }
    }

    public void begin() {
        if (!this.softBegin.compareAndSet(false, true)) {
            throw new IllegalStateException("Transaction already active");
        }
    }

    private void beginInternal() throws IOException {
        this.init();
        this.parallelInserter = new ParallelRDFInserter(this.repository, new ParserConfig(), this.repository.getValueFactory(), (RepositoryMonitorTrackRecordHelper)new RepositoryMonitorTrackRecordHelperSE(new RepositoryMonitorNotifiable(this){

            public RepositoryMonitorTrackRecordImpl createTrackRecord(long l) {
                return new RepositoryMonitorTrackRecordImpl(l);
            }

            public void registerTrackRecord(RepositoryMonitorTrackRecordImpl repositoryMonitorTrackRecord) {
            }

            public void removeTrackRecord(RepositoryMonitorTrackRecordImpl repositoryMonitorTrackRecord) {
            }
        }));
        this.parallelInserter.begin(true);
        this.closeOwlimConnection();
        this.owlimConnection = this.parallelInserter.getOwlimConnection();
    }

    private void closeOwlimConnection() {
        if (this.owlimConnection != null) {
            if (this.owlimConnection.getEntityPoolConnection().isOpen()) {
                this.owlimConnection.getEntityPoolConnection().rollback();
            }
            this.owlimConnection.close();
            this.owlimConnection = null;
        }
    }

    public void rollback() {
        if (this.parallelInserter != null) {
            this.parallelInserter.rollback();
            this.parallelInserter = null;
            this.softBegin.set(false);
            this.closeOwlimConnection();
        }
    }

    public void commit() {
        if (this.parallelInserter != null) {
            this.parallelInserter.commit();
            this.parallelInserter = null;
            this.softBegin.set(false);
            this.closeOwlimConnection();
        }
    }

    public void add(Resource subj, IRI pred, Value obj, Resource ... contexts) {
        if (subj == null || pred == null || obj == null) {
            throw new UnsupportedOperationException("Incomplete statement");
        }
        if (!this.softBegin.get()) {
            throw new IllegalStateException("Transaction not active");
        }
        try {
            if (this.parallelInserter == null) {
                this.beginInternal();
            }
            this.parallelInserter.addStatement(subj, pred, obj, null, contexts);
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.initialised.get()) {
            if (this.parallelInserter != null) {
                this.rollback();
            }
            if (this.statements != null) {
                this.statements.close();
            }
            this.closeOwlimConnection();
            this.repository.shutDown();
            FileUtils.deleteDirectory((File)this.directory);
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public Entities getEntities() {
        return new Entities(){
            final Entities entities;
            {
                this.entities = TemporaryGraph.this.getOwlimConnection().getEntityPoolConnection().getEntities();
            }

            public Value get(long id) {
                return this.entities.get(id);
            }

            public Entities.Type getType(long id) {
                return this.entities.getType(id);
            }

            public String getLanguage(long id) {
                return this.entities.getLanguage(id);
            }

            public IRI getDatatype(long id) {
                return this.entities.getDatatype(id);
            }

            public long getClass(long id) {
                return this.entities.getClass(id);
            }

            public long put(Value value, Entities.Scope scope) {
                if (scope == Entities.Scope.REQUEST) {
                    return this.entities.put(value, scope);
                }
                if (scope == Entities.Scope.DEFAULT) {
                    long id = this.resolve(value);
                    if (id == 0L) {
                        TemporaryGraph.this.logger.warn("Create connector with static data uses an IRI that wasn't part of the data, check your connector definition and data: {}", (Object)value);
                        return Long.MAX_VALUE;
                    }
                    return id;
                }
                throw new IllegalStateException("Temporary graph should never be used for SYSTEM scope entities");
            }

            public long replace(long id, Value value, Entities.Scope scope) {
                return this.entities.replace(id, value, scope);
            }

            public long resolve(Value value) {
                return this.entities.resolve(value);
            }

            public long size() {
                return this.entities.size();
            }

            public boolean isTransactional() {
                return this.entities.isTransactional();
            }

            public int getEntityIdSize() {
                return this.entities.getEntityIdSize();
            }
        };
    }

    public synchronized Statements getStatements() {
        if (this.parallelInserter != null) {
            throw new IllegalStateException("No statements while in parallel transaction");
        }
        if (this.statements == null) {
            this.statements = new StatementsImpl(null, this.getOwlimConnection().getRepositoryConnection());
        }
        return this.statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IRI> predicates() {
        HashSet<IRI> result = new HashSet<IRI>();
        try (PredicateIterator pitty = this.getOwlimConnection().getRepositoryConnection().getPredicates();
             EntityPoolConnection eConn = this.repository.getEntities().getConnection();){
            while (pitty.hasNext()) {
                pitty.next();
                Value value = eConn.getValue(pitty.predicate);
                if (!(value instanceof IRI)) continue;
                result.add((IRI)value);
            }
        }
        return result;
    }

    private OwlimConnection getOwlimConnection() {
        if (this.owlimConnection == null) {
            this.owlimConnection = this.repository.getOwlimConnection();
            this.owlimConnection.getEntityPoolConnection().begin();
        }
        return this.owlimConnection;
    }

    public SailConnection getSailConnection() {
        return this.repository.getConnection();
    }
}

