/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.config.validators;

import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.validators.Validator;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class URIValidator
implements Validator<String> {
    public String validate(@Nullable String value, Options optionsSet) {
        if (value == null) {
            return null;
        }
        try {
            if ("$self".equals(value) || "@".equals(value)) {
                return "The pseudo URI " + value + " may only be used in a chain with a single property.";
            }
            if ("lang()".equalsIgnoreCase(value) || "graph()".equalsIgnoreCase(value) || "$literal".equalsIgnoreCase(value) || "localname()".equalsIgnoreCase(value)) {
                return "The pseudo URI " + value + " may only be used as the last (but not first) property in a chain.";
            }
            SimpleValueFactory.getInstance().createIRI(value);
            return null;
        }
        catch (IllegalArgumentException ex) {
            String message = ex.getMessage();
            return message == null || message.isEmpty() ? "Not a valid uri '" + value + "'. " : message;
        }
    }
}

