/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sparql;

import com.ontotext.graphdb.raft.grpc.Binding;
import com.ontotext.graphdb.raft.grpc.Data;
import com.ontotext.graphdb.raft.grpc.Query;
import com.ontotext.graphdb.replicationcluster.LocalConsistency;
import com.ontotext.raft.GraphDBLoadBalancer;
import com.ontotext.raft.evaluate.ClosableClusterQueryIterator;
import com.ontotext.trree.query.evaluation.GraphDBBindingSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.SimpleDataset;
import org.eclipse.rdf4j.query.resultio.QueryResultFormat;
import org.eclipse.rdf4j.query.resultio.QueryResultIO;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultParser;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDBLoadBalancedRepositoryConnection
extends RepositoryConnectionWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String repositoryId;
    private final LoadBalancedEvaluator evaluator;

    public GraphDBLoadBalancedRepositoryConnection(String repositoryId, Repository repository, RepositoryConnection delegate, GraphDBLoadBalancer loadBalancer, ExecutorService executorService) {
        super(repository, delegate);
        this.repositoryId = repositoryId;
        this.evaluator = new LoadBalancedEvaluator(loadBalancer, executorService, delegate);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
        Query.Builder queryBuilder = com.ontotext.graphdb.raft.grpc.Query.newBuilder().setQuery(query).setRepository(this.repositoryId).setMime(TupleQueryResultFormat.BINARY.getDefaultMIMEType());
        if (baseURI != null) {
            queryBuilder.setBase(baseURI);
        }
        queryBuilder.setIsSOSSplitQuery(true);
        queryBuilder.setSplitQueryLimit(Integer.MAX_VALUE);
        return new TupleLoadBalancedQuery(queryBuilder, this.getValueFactory(), this.evaluator);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        Query.Builder queryBuilder = com.ontotext.graphdb.raft.grpc.Query.newBuilder().setQuery(query).setRepository(this.repositoryId).setMime(RDFFormat.BINARY.getDefaultMIMEType());
        if (baseURI != null) {
            queryBuilder.setBase(baseURI);
        }
        return new GraphLoadBalancedQuery(queryBuilder, this.getValueFactory(), this.evaluator);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        Query.Builder queryBuilder = com.ontotext.graphdb.raft.grpc.Query.newBuilder().setQuery(query).setRepository(this.repositoryId);
        if (baseURI != null) {
            queryBuilder.setBase(baseURI);
        }
        return new BooleanLoadBalancedQuery(queryBuilder, this.getValueFactory(), this.evaluator);
    }

    private static class LoadBalancedEvaluator {
        private final GraphDBLoadBalancer loadBalancer;
        private final ExecutorService executorService;
        private final RepositoryConnection connection;

        public LoadBalancedEvaluator(GraphDBLoadBalancer loadBalancer, ExecutorService executorService, RepositoryConnection connection) {
            this.loadBalancer = loadBalancer;
            this.executorService = executorService;
            this.connection = connection;
        }

        public void evaluateTupleQuery(com.ontotext.graphdb.raft.grpc.Query query, TupleQueryResultHandler tupleQueryResultHandler) {
            this.evaluate(this.executeTupleQuery(query), this.readTupleResults(tupleQueryResultHandler));
        }

        private Function<GraphDBLoadBalancer, Iterator<Data>> executeTupleQuery(com.ontotext.graphdb.raft.grpc.Query query) {
            return balancer -> balancer.evaluateTupleQuery(query, LocalConsistency.LAST_COMMITTED, this.connection);
        }

        private QueryResponseConsumer readTupleResults(TupleQueryResultHandler tupleQueryResultHandler) {
            return inputStream -> {
                TupleQueryResultParser tupleParser = QueryResultIO.createTupleParser((QueryResultFormat)TupleQueryResultFormat.BINARY, (ValueFactory)this.connection.getValueFactory());
                tupleParser.setQueryResultHandler((QueryResultHandler)tupleQueryResultHandler);
                tupleParser.parseQueryResult(inputStream);
            };
        }

        public void evaluateGraphQuery(com.ontotext.graphdb.raft.grpc.Query query, RDFHandler rdfHandler) {
            this.evaluate(this.executeGraphQuery(query), this.readGraphResults(rdfHandler));
        }

        private Function<GraphDBLoadBalancer, Iterator<Data>> executeGraphQuery(com.ontotext.graphdb.raft.grpc.Query query) {
            return balancer -> balancer.evaluateGraphQuery(query, LocalConsistency.LAST_COMMITTED, this.connection);
        }

        private QueryResponseConsumer readGraphResults(RDFHandler rdfHandler) {
            return inputStream -> {
                RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.BINARY, (ValueFactory)this.connection.getValueFactory());
                rdfParser.setRDFHandler(rdfHandler);
                rdfParser.parse(inputStream);
            };
        }

        public boolean evaluateBooleanQuery(com.ontotext.graphdb.raft.grpc.Query query) {
            return this.loadBalancer.evaluateBooleanQuery(query, LocalConsistency.LAST_COMMITTED, this.connection);
        }

        void evaluate(Function<GraphDBLoadBalancer, Iterator<Data>> dataProvider, QueryResponseConsumer responseConsumer) {
            PipedOutputStream outputStream;
            PipedInputStream inputStream = new PipedInputStream();
            try {
                outputStream = new PipedOutputStream(inputStream);
            }
            catch (IOException ioe) {
                throw new QueryEvaluationException((Throwable)ioe);
            }
            Future<?> future = this.executorService.submit(() -> {
                block21: {
                    boolean hasError = false;
                    try {
                        Iterator iterator = (Iterator)dataProvider.apply(this.loadBalancer);
                        if (iterator instanceof ClosableClusterQueryIterator) {
                            try (ClosableClusterQueryIterator closableResultIterator = (ClosableClusterQueryIterator)iterator;){
                                this.iterateQueryResult((Iterator<Data>)closableResultIterator, outputStream);
                                break block21;
                            }
                        }
                        this.iterateQueryResult(iterator, outputStream);
                    }
                    catch (Exception ioe) {
                        hasError = true;
                        if (outputStream != null) {
                            try {
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException nested) {
                                ioe.addSuppressed(nested);
                            }
                        }
                        if (ioe instanceof QueryEvaluationException) {
                            throw (QueryEvaluationException)ioe;
                        }
                        throw new QueryEvaluationException((Throwable)ioe);
                    }
                    finally {
                        if (outputStream != null && !hasError) {
                            try {
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException ioe) {
                                throw new QueryEvaluationException((Throwable)ioe);
                            }
                        }
                    }
                }
            });
            try (PipedInputStream pipedInputStream = inputStream;){
                responseConsumer.consumeResponse(inputStream);
            }
            catch (IOException ioe) {
                if (future.cancel(true)) {
                    LOGGER.debug("Query interrupted successfully. Cause: ", (Throwable)ioe);
                }
                throw new QueryEvaluationException((Throwable)ioe);
            }
            finally {
                if (future.isDone()) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException ie) {
                        Thread.interrupted();
                        throw new QueryEvaluationException((Throwable)ie);
                    }
                    catch (ExecutionException ee) {
                        Throwable cause = ee.getCause();
                        if (cause instanceof QueryEvaluationException) {
                            throw (QueryEvaluationException)cause;
                        }
                        throw new QueryEvaluationException(cause);
                    }
                }
            }
        }

        private void iterateQueryResult(Iterator<Data> resultIterator, OutputStream out) throws IOException {
            while (resultIterator.hasNext()) {
                Data data = resultIterator.next();
                if (!data.getError().isEmpty()) {
                    throw new QueryEvaluationException(data.getError());
                }
                if (!data.getWarn().isEmpty()) {
                    LOGGER.warn(data.getWarn());
                }
                out.write(data.getData().toByteArray());
            }
        }
    }

    private static class TupleLoadBalancedQuery
    extends LoadBalancedQuery
    implements TupleQuery {
        private final LoadBalancedEvaluator evaluator;

        TupleLoadBalancedQuery(Query.Builder queryBuilder, ValueFactory valueFactory, LoadBalancedEvaluator evaluator) {
            super(queryBuilder, valueFactory);
            this.evaluator = evaluator;
        }

        public TupleQueryResult evaluate() throws QueryEvaluationException {
            throw new UnsupportedOperationException("Use evaluate(TupleQueryResultHandler) instead!");
        }

        public void evaluate(TupleQueryResultHandler tupleQueryResultHandler) throws QueryEvaluationException, TupleQueryResultHandlerException {
            this.evaluator.evaluateTupleQuery(this.queryBuilder.build(), tupleQueryResultHandler);
        }
    }

    private static class GraphLoadBalancedQuery
    extends LoadBalancedQuery
    implements GraphQuery {
        private final LoadBalancedEvaluator evaluator;

        GraphLoadBalancedQuery(Query.Builder queryBuilder, ValueFactory valueFactory, LoadBalancedEvaluator evaluator) {
            super(queryBuilder, valueFactory);
            this.evaluator = evaluator;
        }

        public GraphQueryResult evaluate() throws QueryEvaluationException {
            return null;
        }

        public void evaluate(RDFHandler rdfHandler) throws QueryEvaluationException, RDFHandlerException {
            this.evaluator.evaluateGraphQuery(this.queryBuilder.build(), rdfHandler);
        }
    }

    private static class BooleanLoadBalancedQuery
    extends LoadBalancedQuery
    implements BooleanQuery {
        private final LoadBalancedEvaluator evaluator;

        BooleanLoadBalancedQuery(Query.Builder queryBuilder, ValueFactory valueFactory, LoadBalancedEvaluator evaluator) {
            super(queryBuilder, valueFactory);
            this.evaluator = evaluator;
        }

        public boolean evaluate() throws QueryEvaluationException {
            return this.evaluator.evaluateBooleanQuery(this.queryBuilder.build());
        }
    }

    private static class LoadBalancedQuery
    implements Query {
        final Query.Builder queryBuilder;
        private final ValueFactory valueFactory;

        private LoadBalancedQuery(Query.Builder queryBuilder, ValueFactory valueFactory) {
            this.queryBuilder = queryBuilder;
            this.valueFactory = valueFactory;
        }

        public void setMaxQueryTime(int i) {
        }

        public int getMaxQueryTime() {
            return 0;
        }

        public void setBinding(String binding, Value value) {
            this.queryBuilder.addParameters(Binding.newBuilder().setName(binding).setEncodedValue(Protocol.encodeValue((Value)value)));
        }

        public void removeBinding(String binding) {
            throw new UnsupportedOperationException();
        }

        public void clearBindings() {
            this.queryBuilder.clearParameters();
        }

        public BindingSet getBindings() {
            List parametersList = this.queryBuilder.getParametersList();
            GraphDBBindingSet bindings = new GraphDBBindingSet(parametersList.size());
            for (Binding binding : parametersList) {
                bindings.addBinding(binding.getName(), Protocol.decodeValue((String)binding.getEncodedValue(), (ValueFactory)this.valueFactory));
            }
            return bindings;
        }

        public void setDataset(Dataset dataset) {
            if (dataset != null) {
                for (IRI defaultGraph : dataset.getDefaultGraphs()) {
                    this.queryBuilder.addDefaultGraphs(defaultGraph.stringValue());
                }
                for (IRI namedGraph : dataset.getNamedGraphs()) {
                    this.queryBuilder.addNamedGraphs(namedGraph.stringValue());
                }
            }
        }

        public Dataset getDataset() {
            SimpleDataset dataset = new SimpleDataset();
            for (String defaultGraph : this.queryBuilder.getDefaultGraphsList()) {
                dataset.addDefaultGraph(this.valueFactory.createIRI(defaultGraph));
            }
            for (String namedGraph : this.queryBuilder.getNamedGraphsList()) {
                dataset.addNamedGraph(this.valueFactory.createIRI(namedGraph));
            }
            return dataset;
        }

        public void setIncludeInferred(boolean includeInferred) {
            this.queryBuilder.setIncludeInferred(includeInferred);
        }

        public boolean getIncludeInferred() {
            return this.queryBuilder.getIncludeInferred();
        }

        public void setMaxExecutionTime(int i) {
        }

        public int getMaxExecutionTime() {
            return 0;
        }
    }

    static interface QueryResponseConsumer {
        public void consumeResponse(InputStream var1) throws IOException;
    }
}

