/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.security;

import com.ontotext.forest.security.utils.SecurityUtils;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.soaas.plugin.Order;

@Order(value=1900)
public class GraphQLRepositoryAccessValidator
implements OperationValidator {
    public OperationResponse validate(Operation operation, ValidationContext validationContext) {
        OperationResponse operationResponse = new OperationResponse();
        String repository = operation.getArguments().getRepository().orElse(null);
        boolean isMutation = operation.getOperationType().isMutation();
        if (repository != null && !SecurityUtils.hasGraphQLRepositoryAccess((String)repository, (boolean)isMutation)) {
            operationResponse.addError(String.format("No GraphQL %s rights for repository %s", isMutation ? "write" : "read", repository));
        }
        return operationResponse;
    }
}

