/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.controller.responses;

import com.ontotext.forest.graphql.controller.responses.ErrorResponse;
import com.ontotext.forest.graphql.controller.responses.ResponseMessage;
import com.ontotext.forest.graphql.controller.responses.WarningResponse;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.Severity;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.WarningCode;
import com.ontotext.soaas.common.logging.LoggingContext;
import java.util.function.Function;
import org.apache.commons.lang3.ObjectUtils;

public class ResponseMapper {
    private static final String MISSING_REQUEST_ID = "MISSING_X_REQUEST_ID";

    private ResponseMapper() {
    }

    public static Function<OperationResponse.OperationMessage, ErrorResponse> toErrorResponse() {
        String requestId = ResponseMapper.getRequestId();
        return message -> ResponseMapper.toError(requestId, message.toString());
    }

    private static ErrorResponse toError(String requestId, String message) {
        return new ErrorResponse(requestId, ErrorCode.MALFORMED_SOML, message);
    }

    public static Function<OperationResponse.OperationMessage, WarningResponse> toWarningResponse() {
        String requestId = ResponseMapper.getRequestId();
        return message -> ResponseMapper.toWarning(requestId, message.toString());
    }

    private static WarningResponse toWarning(String requestId, String message) {
        return new WarningResponse(requestId, WarningCode.SOML_WARNINGS, message);
    }

    public static ResponseMessage transform(String message, Severity messageType) {
        switch (messageType) {
            case WARN: {
                return ResponseMapper.toWarning(ResponseMapper.getRequestId(), message);
            }
            case ERROR: 
            case FATAL: {
                return ResponseMapper.toError(ResponseMapper.getRequestId(), message);
            }
        }
        throw new IllegalArgumentException("Unsupported message type: " + String.valueOf(messageType));
    }

    public static String getRequestId() {
        return (String)ObjectUtils.defaultIfNull((Object)LoggingContext.getRequestId(), (Object)MISSING_REQUEST_ID);
    }
}

