/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.controller;

import com.google.common.collect.ImmutableMap;
import com.ontotext.forest.core.error.ErrorMessage;
import com.ontotext.metamodel.storage.MalformedSomlException;
import com.ontotext.metamodel.storage.SchemaIdMismatchException;
import com.ontotext.metamodel.storage.SomlAlreadyExistsException;
import com.ontotext.metamodel.storage.SomlNotFoundException;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.soaas.common.ErrorCode;
import java.util.Map;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@Order(value=100)
@ControllerAdvice
public class SomlStoreExceptionHandler {
    private static final Map<Class<?>, ErrorCode> SOML_EXCEPTIONS = ImmutableMap.builder().put(SomlAlreadyExistsException.class, (Object)ErrorCode.CONFLICT_SOML).put(SchemaIdMismatchException.class, (Object)ErrorCode.SCHEMA_ID_MISMATCH).put(UnreachableStoreException.class, (Object)ErrorCode.SOML_STORE_UNREACHABLE).put(SomlNotFoundException.class, (Object)ErrorCode.MISSING_SOML).put(SomlStoreException.class, (Object)ErrorCode.UNHANDLED_RUNTIME).put(MalformedSomlException.class, (Object)ErrorCode.MALFORMED_SOML).build();

    @ExceptionHandler
    public ResponseEntity<Object> handleSomlStoreException(SomlStoreException ex) {
        ErrorCode errorCode = SOML_EXCEPTIONS.getOrDefault(ex.getClass(), ErrorCode.UNHANDLED_RUNTIME);
        HttpStatus responseStatus = HttpStatus.resolve((int)errorCode.getHttpCode());
        if (responseStatus == null) {
            responseStatus = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return new ResponseEntity((Object)new ErrorMessage(ex.getMessage()), (HttpStatusCode)responseStatus);
    }
}

