/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.controller;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.ontotext.soaas.query.service.GraphQlQueryRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;

@Schema(name="GraphQLRequest", description="Wrapper for GraphQL request body containing query, variables, and operationName.", example="{\n  \"query\": \"query { object { id } }\",\n  \"variables\": {},\n  \"operationName\": null\n}")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonPropertyOrder(value={"query", "variables", "operationName"})
public class GraphQLRequest {
    public static final String SPRINGDOC_GRAPHQL_REQUEST_EXAMPLE = "{\n  \"query\": \"query { object { id } }\",\n  \"variables\": {},\n  \"operationName\": null\n}";
    @JsonProperty
    private String query;
    @JsonProperty
    private Map<String, Object> variables;
    @JsonProperty
    private String operationName;

    @JsonIgnore
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    @JsonIgnore
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    @JsonIgnore
    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    @JsonIgnore
    GraphQlQueryRequest asGraphQlQueryRequest() {
        return GraphQlQueryRequest.from((String)this.getQuery(), this.getVariables(), (String)this.getOperationName());
    }
}

