/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.controller;

import com.ontotext.forest.core.proxy.ProxyToRemoteSesame;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.graphql.cluster.LoadBalancedGraphQLServiceEndpoint;
import com.ontotext.forest.graphql.controller.GraphQLRequest;
import com.ontotext.forest.graphql.controller.SimpleGraphQlQueryRequest;
import com.ontotext.forest.graphql.controller.responses.GraphQLEndpoint;
import com.ontotext.forest.graphql.controller.responses.GraphQLResponse;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.soaas.query.service.GraphQlQueryRequest;
import com.ontotext.soaas.query.service.RequestConfig;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/repositories"})
@Tag(name="GraphQL API", description="Manage and invoke GraphQL requests")
public class GraphQLController {
    private final SemanticDataManagement semanticDataManagement;
    private final ProxyToRemoteSesame proxyToRemoteSesame;
    private static final Logger logger = Loggers.graphqlLogger();
    private static final String ACCEPT_HEADER_SEPARATOR = ",";
    private static final String API_ACCEPT = "application/graphql,application/json";
    private final LoadBalancedGraphQLServiceEndpoint serviceEndpoint;

    @Autowired
    public GraphQLController(SemanticDataManagement semanticDataManagement, ProxyToRemoteSesame proxyToRemoteSesame, LoadBalancedGraphQLServiceEndpoint serviceEndpoint) {
        this.semanticDataManagement = semanticDataManagement;
        this.proxyToRemoteSesame = proxyToRemoteSesame;
        this.serviceEndpoint = serviceEndpoint;
    }

    @Operation(summary="List all active GraphQL endpoints", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=GraphQLEndpoint.class)))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{repository}/graphql/endpoints"}, produces={"application/json"})
    public ResponseEntity<?> getEndpoints(@Parameter(description="Target repository", required=true) @PathVariable(value="repository") String repository, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return (ResponseEntity)this.proxyToRemoteSesame.proxyToRemoteIfNeeded(request, response, repository, this.semanticDataManagement, () -> {
            try {
                return ResponseEntity.ok(this.serviceEndpoint.getActiveEndpoints(repository));
            }
            catch (UnreachableStoreException e) {
                return ResponseEntity.internalServerError().build();
            }
        });
    }

    @Operation(summary="Query default GraphQL schema", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GraphQLResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{repository}/graphql"}, produces={"application/json"})
    public void queryDefaultEndpoint(@Parameter(description="Target repository", required=true) @PathVariable(value="repository") String repository, @Parameter(name="query", description="GraphQL request to evaluate", schema=@Schema(type="string", example="query {\n    object {\n    id\n  }\n}"), required=true) @RequestParam String query, @Parameter(name="variables", description="Map of query request variables", schema=@Schema(type="string", example="{}"), in=ParameterIn.QUERY) @RequestParam(required=false) String variables, @Parameter(name="operationName", description="The GraphQL operation to execute", schema=@Schema(type="string", nullable=true), in=ParameterIn.QUERY) @RequestParam(required=false) String operationName, @Parameter(hidden=true) @ModelAttribute(value="requestConfig") RequestConfig requestConfig, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, repository, this.semanticDataManagement, () -> {
            GraphQlQueryRequest queryRequest = GraphQlQueryRequest.from((String)query, (Object)variables, (String)operationName);
            this.serviceEndpoint.evaluateQuery(repository, null, queryRequest, requestConfig, servletResponse);
            return null;
        });
    }

    @Operation(summary="Query specific GraphQL schema", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GraphQLResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))})})
    @GetMapping(path={"{repository}/graphql/{schemaId}"}, produces={"application/json"})
    public void querySpecificEndpoint(@Parameter(description="Target repository", required=true) @PathVariable(value="repository") String repository, @Parameter(description="Schema identifier", required=true) @PathVariable(value="schemaId") String schemaId, @Parameter(name="query", description="GraphQL request to evaluate", schema=@Schema(type="string", example="query {\n    object {\n    id\n  }\n}"), required=true) @RequestParam String query, @Parameter(name="variables", description="Map of query request variables", schema=@Schema(type="string", example="{}"), in=ParameterIn.QUERY) @RequestParam(required=false) String variables, @Parameter(name="operationName", description="The GraphQL operation to execute", schema=@Schema(type="string", nullable=true), in=ParameterIn.QUERY) @RequestParam(required=false) String operationName, @Parameter(hidden=true) @ModelAttribute(value="requestConfig") RequestConfig requestConfig, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        this.proxyToRemoteSesame.proxyToRemoteIfNeeded(servletRequest, servletResponse, repository, this.semanticDataManagement, () -> {
            GraphQlQueryRequest queryRequest = GraphQlQueryRequest.from((String)query, (Object)variables, (String)operationName);
            this.serviceEndpoint.evaluateQuery(repository, schemaId, queryRequest, requestConfig, servletResponse);
            return null;
        });
    }

    @Operation(summary="Query default GraphQL schema", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GraphQLResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content})}, requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="GraphQL query string", required=true, content={@Content(mediaType="application/graphql", schema=@Schema(implementation=SimpleGraphQlQueryRequest.class))}))
    @PostMapping(path={"{repository}/graphql"}, consumes={"application/graphql"}, produces={"application/json"})
    public void postGraphQl(@Parameter(description="Target repository", required=true) @PathVariable(value="repository") String repository, @RequestBody SimpleGraphQlQueryRequest query, @Parameter(name="variables", description="Map of query request variables", schema=@Schema(type="string", example="{}"), in=ParameterIn.QUERY) @RequestParam(required=false) String variables, @Parameter(description="The GraphQL operation to execute", in=ParameterIn.QUERY) @RequestParam(required=false) String operationName, @Parameter(hidden=true) @ModelAttribute(value="requestConfig") RequestConfig requestConfig, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)query, servletRequest, servletResponse, repository, this.semanticDataManagement, () -> {
            GraphQlQueryRequest queryRequest = GraphQlQueryRequest.from((String)query.getQuery(), (Object)variables, (String)operationName);
            this.serviceEndpoint.evaluateQuery(repository, null, queryRequest, requestConfig, servletResponse);
            return null;
        });
    }

    @Operation(summary="Query specific GraphQL schema", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GraphQLResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content})}, requestBody=@io.swagger.v3.oas.annotations.parameters.RequestBody(description="GraphQL query string", required=true, content={@Content(mediaType="application/graphql", schema=@Schema(implementation=SimpleGraphQlQueryRequest.class))}))
    @PostMapping(path={"{repository}/graphql/{schemaId}"}, consumes={"application/graphql"}, produces={"application/json"})
    public void postGraphQl(@Parameter(description="Target repository", required=true, in=ParameterIn.PATH) @PathVariable(value="repository") String repository, @Parameter(description="Schema identifier", required=true, in=ParameterIn.PATH) @PathVariable(value="schemaId") String schemaId, @RequestBody SimpleGraphQlQueryRequest query, @Parameter(name="variables", description="Map of query request variables", schema=@Schema(type="string", example="{}"), in=ParameterIn.QUERY) @RequestParam(required=false) String variables, @Parameter(description="The GraphQL operation to execute", in=ParameterIn.QUERY) @RequestParam(required=false) String operationName, @Parameter(hidden=true) @ModelAttribute(value="requestConfig") RequestConfig requestConfig, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)query, servletRequest, servletResponse, repository, this.semanticDataManagement, () -> {
            GraphQlQueryRequest queryRequest = GraphQlQueryRequest.from((String)query.getQuery(), (Object)variables, (String)operationName);
            this.serviceEndpoint.evaluateQuery(repository, schemaId, queryRequest, requestConfig, servletResponse);
            return null;
        });
    }

    @Operation(summary="Query default GraphQL schema", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GraphQLResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content})})
    @PostMapping(path={"{repository}/graphql"}, consumes={"application/json"}, produces={"application/json"})
    public void post(@Parameter(description="Target repository", required=true) @PathVariable(value="repository") String repository, @Valid @RequestBody GraphQLRequest request, @Parameter(hidden=true) @ModelAttribute(value="requestConfig") RequestConfig requestConfig, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)request, servletRequest, servletResponse, repository, this.semanticDataManagement, () -> {
            this.serviceEndpoint.evaluateQuery(repository, null, request.asGraphQlQueryRequest(), requestConfig, servletResponse);
            return null;
        });
    }

    @Operation(summary="Query specific GraphQL schema", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=GraphQLResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content}), @ApiResponse(responseCode="404", description="Not Found", content={@Content}), @ApiResponse(responseCode="409", description="Conflict", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="412", description="Precondition Failed", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Internal Server Error", content={@Content})})
    @PostMapping(path={"{repository}/graphql/{schemaId}"}, consumes={"application/json"}, produces={"application/json"})
    public void postGraphQl(@Parameter(description="Target repository", required=true, in=ParameterIn.PATH) @PathVariable(value="repository") String repository, @Parameter(description="Schema identifier", required=true, in=ParameterIn.PATH) @PathVariable(value="schemaId") String schemaId, @Valid @RequestBody GraphQLRequest request, @Parameter(hidden=true) @ModelAttribute(value="requestConfig") RequestConfig requestConfig, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        this.proxyToRemoteSesame.proxyWithBodyToRemoteIfNeeded((Object)request, servletRequest, servletResponse, repository, this.semanticDataManagement, () -> {
            this.serviceEndpoint.evaluateQuery(repository, schemaId, request.asGraphQlQueryRequest(), requestConfig, servletResponse);
            return null;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ModelAttribute(value="requestConfig")
    RequestConfig buildRequestConfig(@RequestHeader(required=false, name="Accept", defaultValue="application/json") String acceptType, @RequestHeader(required=false, name="Accept-Language") String acceptLanguage) {
        List contentTypes = Stream.of(acceptType.split(ACCEPT_HEADER_SEPARATOR)).map(StringUtils::trim).filter(this.isSupportedContentType().or(Predicate.isEqual("*/*"))).collect(Collectors.toList());
        boolean requestedAny = contentTypes.remove("*/*");
        if (contentTypes.isEmpty()) {
            if (!requestedAny) throw new UnsupportedOperationException();
            acceptType = "application/json";
            return new RequestConfig(acceptType, acceptLanguage);
        } else {
            acceptType = (String)contentTypes.get(0);
        }
        return new RequestConfig(acceptType, acceptLanguage);
    }

    private Predicate<String> isSupportedContentType() {
        return requestType -> requestType.startsWith("application/json");
    }
}

