/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphql.cluster;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.forest.graphql.GraphQLService;
import com.ontotext.forest.graphql.controller.requests.GraphQLSchemaCreateRequest;
import com.ontotext.forest.graphql.controller.requests.UpdateEndpointRequest;
import com.ontotext.forest.graphql.controller.responses.ConfigOption;
import com.ontotext.forest.graphql.controller.responses.GraphQLEndpoint;
import com.ontotext.forest.graphql.controller.responses.GraphQLEndpointReport;
import com.ontotext.forest.graphql.controller.responses.ImportResponse;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.graphql.RdfToSomlConversionManager;
import com.ontotext.graphdb.graphql.config.SimpleGraphQLSchemaCreateRequest;
import com.ontotext.graphdb.statistics.StatisticsListener;
import com.ontotext.graphdb.statistics.models.GraphQL;
import com.ontotext.graphdb.statistics.models.enums.EndpointCreationType;
import com.ontotext.metamodel.storage.SchemaEntity;
import com.ontotext.metamodel.storage.SomlStoreException;
import com.ontotext.metamodel.storage.UnreachableStoreException;
import com.ontotext.platform.owl2soml.ConversionException;
import com.ontotext.platform.owl2soml.GraphQlSchemaShape;
import com.ontotext.platform.owl2soml.Message;
import com.ontotext.platform.owl2soml.Owl2SomlConverter;
import com.ontotext.platform.owl2soml.PrefixNamespaceResponse;
import com.ontotext.soaas.common.logging.Loggers;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.monitorRepository.MonitorRepository;
import com.ontotext.validator.data.ValidationJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@Component
public class GraphQLManagementService
implements ApplicationListener<PropertyChangedEvent> {
    public static final String NO_ACTIVE_REPO_CUSTOM_ERROR_MSG = "Please specify an existing repository in the request or ensure an active repository.";
    private static final long BYTES_IN_KB = 1024L;
    private static final long BYTES_IN_MB = 0x100000L;
    private static final long BYTES_IN_GB = 0x40000000L;
    private static final long BYTES_IN_TB = 0x10000000000L;
    private static final long BYTES_IN_PB = 0x4000000000000L;
    private final long MAX_ENTRY_SIZE = Config.getPropertyAsLong((String)"graphdb.graphql.import.maxFileSizeBytes", (long)0xA00000L);
    private final int MAX_FILE_NUMBER = Config.getPropertyAsInt((String)"graphdb.graphql.import.maxFilesCount", (int)200);
    private static final int BUFFER_SIZE = 4096;
    private static final Logger logger = Loggers.graphqlLogger();
    private final GraphQLService serviceEndpoint;
    private final SemanticDataManagement semanticDataManagement;
    private boolean serverInitialized;
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private volatile Boolean hasCluster;

    @Autowired
    public GraphQLManagementService(GraphQLService serviceEndpoint, SemanticDataManagement semanticDataManagement) {
        this.serviceEndpoint = serviceEndpoint;
        this.semanticDataManagement = semanticDataManagement;
    }

    public List<GraphQLEndpoint> getAllEndpoints(String repository) throws UnreachableStoreException {
        this.waitServerInit();
        return this.serviceEndpoint.getAllEndpoints(repository);
    }

    public List<GraphQLEndpointReport> getAllEndpointsReport(String repository) throws SomlStoreException {
        this.waitServerInit();
        return this.serviceEndpoint.getAllEndpointsReport(repository);
    }

    public GraphQLEndpointReport getEndpointReport(String repository, String schemaId) throws SomlStoreException {
        this.waitServerInit();
        return this.serviceEndpoint.getEndpointReport(repository, schemaId);
    }

    public void confirmEndpointReport(String repository, String schemaId) throws SomlStoreException {
        this.waitServerInit();
        this.serviceEndpoint.confirmEndpointReport(repository, schemaId);
    }

    public List<PrefixNamespaceResponse> getPossiblePrefixes(String repository) {
        this.waitServerInit();
        return this.serviceEndpoint.getRdfToSomlConversionManager().getPossiblePrefixes(repository);
    }

    public List<ConfigOption> getEndpointOptions(String repository, String schemaId) throws SomlStoreException {
        this.waitServerInit();
        return this.serviceEndpoint.getEndpointOptions(repository, schemaId);
    }

    public List<ConfigOption> getSchemaGenerationOptions(String targetRepo) {
        this.waitServerInit();
        return this.serviceEndpoint.getSchemaGenerationOptions(targetRepo);
    }

    public Collection<GraphQlSchemaShape> getGraphQlSchemaShapes(String repository) {
        this.waitServerInit();
        return this.serviceEndpoint.getRdfToSomlConversionManager().getGraphQlSchemaShapes(repository);
    }

    public Set<IRI> getShaclGraphsForRepository(String repository) {
        this.waitServerInit();
        return this.serviceEndpoint.getShaclGraphsForRepository(repository);
    }

    private void waitServerInit() {
        if (!this.serverInitialized) {
            try {
                logger.warn("Waiting for server to be initialized..");
                this.initLatch.await();
                logger.warn("done");
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(PropertyChangedEvent event) {
        if ("semantic.locations.initialized".equals(event.getKey())) {
            this.serverInitialized = true;
            this.initLatch.countDown();
            return;
        }
        if (this.serverInitialized) {
            GraphQLManagementService graphQLManagementService = this;
            synchronized (graphQLManagementService) {
                if ("cluster.created".equals(event.getKey())) {
                    this.hasCluster = true;
                } else if ("cluster.deleted".equals(event.getKey())) {
                    this.hasCluster = false;
                }
            }
        }
    }

    public GraphQLEndpointReport createNewEndpoint(String repository, SimpleGraphQLSchemaCreateRequest createRequest) throws SomlStoreException {
        this.waitServerInit();
        RdfToSomlConversionManager conversionManager = this.serviceEndpoint.getRdfToSomlConversionManager();
        String id = createRequest.getId();
        String entityId = null;
        String fromRepo = StringUtils.isEmpty((CharSequence)createRequest.getFromRepo()) ? this.semanticDataManagement.getCurrentRepositoryOrThrow(NO_ACTIVE_REPO_CUSTOM_ERROR_MSG).getRepositoryID() : createRequest.getFromRepo();
        try {
            entityId = this.serviceEndpoint.registerNewEndpoint(repository, id, createRequest.getLabel(), createRequest.getDescription(), EndpointCreationType.SHACL_OWL);
            Owl2SomlConverter.Result result = conversionManager.generateNewSchema(fromRepo, createRequest.getNamedGraphs(), createRequest);
            String schema = result.getSchema();
            List messages = result.getMessages();
            return this.serviceEndpoint.createOrUpdateSchema(repository, schema, GraphQLManagementService.createEntityUpdater(messages), EndpointCreationType.SHACL_OWL);
        }
        catch (ConversionException | RuntimeException ex) {
            if (entityId != null) {
                this.serviceEndpoint.storeErrors(entityId, repository, List.of(ex.getMessage()));
            }
            throw new RuntimeException(ex);
        }
    }

    public List<GraphQLEndpointReport> createNewEndpoints(String repository, GraphQLSchemaCreateRequest createRequest) {
        this.waitServerInit();
        RdfToSomlConversionManager conversionManager = this.serviceEndpoint.getRdfToSomlConversionManager();
        LinkedHashMap<String, String> shapeIdToSchemaId = new LinkedHashMap<String, String>();
        String fromRepo = StringUtils.isEmpty((CharSequence)createRequest.getFromRepo()) ? this.semanticDataManagement.getCurrentRepositoryOrThrow(NO_ACTIVE_REPO_CUSTOM_ERROR_MSG).getRepositoryID() : createRequest.getFromRepo();
        LinkedList<GraphQlSchemaShape> schemaShapes = new LinkedList<GraphQlSchemaShape>(conversionManager.getGraphQlSchemaShapes(fromRepo));
        if (CollectionUtils.isNotEmpty(createRequest.getShapes())) {
            schemaShapes.removeIf(shape -> !createRequest.getShapes().contains(shape.getId()));
        }
        for (GraphQlSchemaShape schemaShape : schemaShapes) {
            String localName = SimpleValueFactory.getInstance().createIRI(schemaShape.getId()).getLocalName();
            String label = Objects.toString(schemaShape.getLabel(), schemaShape.getName());
            shapeIdToSchemaId.put(schemaShape.getId(), this.serviceEndpoint.registerNewEndpoint(repository, localName, label, schemaShape.getDescription(), EndpointCreationType.GRAPHQL_SHAPES));
        }
        ArrayList<GraphQLEndpointReport> results = new ArrayList<GraphQLEndpointReport>();
        conversionManager.generateSchemas(fromRepo, schemaShapes, createRequest.getConfig(), (result, error) -> {
            if (result != null) {
                String schema = result.getSchema();
                List messages = result.getMessages();
                GraphQLEndpointReport endpointReport = this.serviceEndpoint.createOrUpdateSchema(repository, schema, GraphQLManagementService.createEntityUpdater(messages), EndpointCreationType.GRAPHQL_SHAPES);
                results.add(endpointReport);
            } else if (error != null) {
                try {
                    logger.error("Error occurred while creating endpoint {}", (Object)error.getShapeId(), (Object)error.getCause());
                    this.serviceEndpoint.storeErrors((String)shapeIdToSchemaId.get(error.getShapeId()), repository, List.of(error.getMessage()));
                }
                catch (SomlStoreException ex) {
                    logger.warn("Could not store errors for {}", (Object)error.getShapeId(), (Object)ex);
                }
            }
        });
        logger.info("Completed endpoints creation. Created {} endpoints", (Object)results.size());
        return results;
    }

    public void deleteSchema(String repository, String endpoint) throws SomlStoreException {
        this.waitServerInit();
        EndpointCreationType endpointCreationType = null;
        boolean handleStatistics = this.isRepoStatisticsCollectionApplicable(repository);
        if (handleStatistics) {
            GraphQLEndpointReport endpointReport = this.serviceEndpoint.getEndpointReport(repository, endpoint);
            endpointCreationType = EndpointCreationType.fromString((String)endpointReport.getEndpointCreationType());
        }
        this.serviceEndpoint.deleteSchema(repository, endpoint);
        if (handleStatistics) {
            this.incrementGraphQlDeletedEndpointsStatistics(repository, endpointCreationType);
        }
    }

    @NotNull
    private static Consumer<SchemaEntity> createEntityUpdater(List<Message> messages) {
        return entity -> {
            entity.setWarnings(entity.getWarnings() + messages.size());
            if (entity.getWarningsMessage() == null) {
                entity.setWarningsMessage(new ArrayList());
            }
            entity.getWarningsMessage().addAll(messages.stream().map(Objects::toString).toList());
            entity.setActive(Boolean.valueOf(entity.getErrors() == 0));
        };
    }

    public GraphQLEndpointReport editEndpoint(String targetRepo, String endpointId, UpdateEndpointRequest updateRequest) throws SomlStoreException {
        this.waitServerInit();
        return this.serviceEndpoint.editEndpoint(targetRepo, endpointId, updateRequest);
    }

    public byte[] exportSchemaAsYaml(String targetRepo, String endpointId) throws IOException {
        this.waitServerInit();
        return this.serviceEndpoint.exportSchemaAsYaml(targetRepo, endpointId);
    }

    public byte[] exportAllSchemasAsZip(String targetRepo) throws UnreachableStoreException {
        this.waitServerInit();
        return this.serviceEndpoint.exportAllSchemasAsZip(targetRepo);
    }

    public List<ImportResponse> importMultipartFiles(String targetRepo, MultipartFile[] files) throws IOException {
        if (files == null || files.length == 0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "No files provided for import.");
        }
        Set emptyFiles = Arrays.stream(files).filter(MultipartFile::isEmpty).map(MultipartFile::getOriginalFilename).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(emptyFiles)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Files " + String.join((CharSequence)", ", emptyFiles) + " are empty.");
        }
        this.waitServerInit();
        ArrayList<ImportResponse> reports = new ArrayList<ImportResponse>();
        block23: for (MultipartFile file : files) {
            String string = file.getContentType();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"text/yaml", "text/x-yaml", "text/yml", "application/x-yaml", "application/x-yml", "application/yaml", "application/yml", "application/zip"}, (Object)string, n)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    reports.add(this.importYamlSchema(targetRepo, file.getBytes(), file.getOriginalFilename()));
                    continue block23;
                }
                case 7: {
                    try (InputStream zipStream = file.getInputStream();){
                        reports.add(this.importSchemasFromZip(targetRepo, zipStream, file.getOriginalFilename()));
                        continue block23;
                    }
                }
                default: {
                    int index = file.getOriginalFilename().lastIndexOf(46);
                    if (index != -1) {
                        String extension;
                        switch (extension = file.getOriginalFilename().substring(index + 1)) {
                            case "yaml": 
                            case "yml": {
                                reports.add(this.importYamlSchema(targetRepo, file.getBytes(), file.getOriginalFilename()));
                                break;
                            }
                            case "zip": {
                                try (InputStream zipStream = file.getInputStream();){
                                    reports.add(this.importSchemasFromZip(targetRepo, zipStream, file.getOriginalFilename()));
                                    continue block23;
                                }
                            }
                            default: {
                                reports.add(this.createSkippedImportResponse(file.getOriginalFilename()));
                                break;
                            }
                        }
                        continue block23;
                    }
                    reports.add(this.createSkippedImportResponse(file.getOriginalFilename()));
                }
            }
        }
        return reports;
    }

    public ImportResponse importYamlSchema(String targetRepo, byte[] yamlBody) {
        this.waitServerInit();
        return this.importYamlSchema(targetRepo, yamlBody, null);
    }

    public ImportResponse importYamlSchema(String targetRepo, byte[] yamlBody, String fileName) {
        if (yamlBody.length == 0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "No files found in the request.");
        }
        return this.serviceEndpoint.importYamlSchema(targetRepo, fileName, new String(yamlBody, StandardCharsets.UTF_8), GraphQLManagementService.createEntityUpdater(List.of()));
    }

    public ImportResponse importSchemasFromZip(String targetRepo, byte[] file) throws IOException {
        if (file.length == 0) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "No files found in the request.");
        }
        if (!this.isValidZipFile(file)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Invalid ZIP file provided");
        }
        this.waitServerInit();
        return this.importSchemasFromZip(targetRepo, new ByteArrayInputStream(file), null);
    }

    public ValidationJob validateSchema(String repository, Set<String> validations, String endpointId, String fetchTasks, Set<String> types, Set<String> properties, Long limit, Long offset, Integer timeout) throws UnreachableStoreException {
        this.waitServerInit();
        return this.serviceEndpoint.validateSchema(repository, validations, endpointId, fetchTasks, types, properties, limit, offset, timeout);
    }

    public GraphQLEndpointReport validateGraphQLSchema(String schema) {
        this.waitServerInit();
        return this.serviceEndpoint.validateGraphQLSchema(schema);
    }

    private ImportResponse importSchemasFromZip(String targetRepo, InputStream zipStream, String fileName) throws IOException {
        ImportResponse response = new ImportResponse();
        response.setFilename(fileName);
        response.setStatus(ImportResponse.ImportStatus.FAIL);
        response.setStatusMessage(String.format("Failed to process file: %s", fileName));
        LinkedHashMap<String, String> schemasInZip = new LinkedHashMap<String, String>();
        ArrayList<ImportResponse> subFiles = new ArrayList<ImportResponse>();
        try (ZipInputStream zis = new ZipInputStream(zipStream);){
            ZipEntry zipEntry;
            int fileCount = 0;
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (!zipEntry.isDirectory() && this.isYamlFile(zipEntry.getName())) {
                    schemasInZip.put(zipEntry.getName(), this.readZipEntry(zis, zipEntry, ++fileCount));
                } else {
                    subFiles.add(this.createSkippedImportResponse(zipEntry.getName()));
                }
                zis.closeEntry();
            }
        }
        if (MapUtils.isNotEmpty(schemasInZip)) {
            subFiles.addAll(schemasInZip.entrySet().stream().map(entry -> this.serviceEndpoint.importYamlSchema(targetRepo, (String)entry.getKey(), (String)entry.getValue(), GraphQLManagementService.createEntityUpdater(List.of()))).toList());
            response.setStatus(ImportResponse.ImportStatus.SUCCESS);
            response.setStatusMessage("Successfully imported file '" + fileName + "'");
        }
        response.setSubFiles(subFiles);
        return response;
    }

    private void incrementGraphQlDeletedEndpointsStatistics(String repository, EndpointCreationType endpointCreationType) {
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
        RepositoryManager repositoryManager = semanticLocation.sesameManager();
        MonitorRepository monitorRepository = (MonitorRepository)repositoryManager.getRepository(repository);
        OwlimSchemaRepository owlim = monitorRepository.getOwlimSail();
        StatisticsListener stats = owlim.getStatistics();
        GraphQL graphQLStatistics = stats.getRepositoryStatistics().getOperations().getGraphQL();
        graphQLStatistics.incrementDeletedEndpoints(endpointCreationType);
    }

    boolean isRepoStatisticsCollectionApplicable(String repository) {
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
        if (semanticLocation == null) {
            return false;
        }
        RepositoryManager repositoryManager = semanticLocation.sesameManager();
        Repository repo = repositoryManager.getRepository(repository);
        if (!(repo instanceof MonitorRepository)) {
            return false;
        }
        MonitorRepository monitorRepository = (MonitorRepository)repo;
        OwlimSchemaRepository owlim = monitorRepository.getOwlimSail();
        if (owlim == null) {
            return false;
        }
        StatisticsListener stats = owlim.getStatistics();
        return stats != null && stats.areStatisticsEnabled();
    }

    private String readZipEntry(ZipInputStream zis, ZipEntry zipEntry, int fileCount) throws IOException {
        int bytesRead;
        if (fileCount > this.MAX_FILE_NUMBER) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "The ZIP file contains too many files: %d (maximum allowed is %d)".formatted(fileCount, this.MAX_FILE_NUMBER));
        }
        if (zipEntry.getSize() > this.MAX_ENTRY_SIZE) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Upload failed: The file '%s' is too large (%s). The maximum allowed size is %s.".formatted(zipEntry.getName(), this.convertLongSizeFileIntoHumanReadable(zipEntry.getSize()), this.convertLongSizeFileIntoHumanReadable(this.MAX_ENTRY_SIZE)));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        long totalBytesRead = 0L;
        while ((bytesRead = zis.read(buffer)) != -1) {
            if ((totalBytesRead += (long)bytesRead) > this.MAX_ENTRY_SIZE) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Zip entry exceeds size limit: " + zipEntry.getName());
            }
            baos.write(buffer, 0, bytesRead);
        }
        return baos.toString(StandardCharsets.UTF_8);
    }

    private ImportResponse createSkippedImportResponse(String fileName) {
        logger.warn("Unsupported file type: {}", (Object)fileName);
        ImportResponse importResponse = new ImportResponse();
        importResponse.setFilename(fileName);
        importResponse.setStatus(ImportResponse.ImportStatus.SKIP);
        importResponse.setStatusMessage("Unsupported file type: " + fileName);
        return importResponse;
    }

    private boolean isYamlFile(String fileName) {
        return fileName.endsWith(".yaml") || fileName.endsWith(".yml");
    }

    private boolean isValidZipFile(byte[] file) {
        return file.length >= 4 && file[0] == 80 && file[1] == 75 && file[2] == 3 && file[3] == 4;
    }

    private String convertLongSizeFileIntoHumanReadable(long fileSizeInBytes) {
        if (fileSizeInBytes == 0L) {
            return "0 MB";
        }
        if (fileSizeInBytes < 1024L) {
            return fileSizeInBytes + " bytes";
        }
        if (fileSizeInBytes < 0x100000L) {
            return this.formatSize(fileSizeInBytes, 1024L, "KB");
        }
        if (fileSizeInBytes < 0x40000000L) {
            return this.formatSize(fileSizeInBytes, 0x100000L, "MB");
        }
        if (fileSizeInBytes < 0x10000000000L) {
            return this.formatSize(fileSizeInBytes, 0x40000000L, "GB");
        }
        if (fileSizeInBytes < 0x4000000000000L) {
            return this.formatSize(fileSizeInBytes, 0x10000000000L, "TB");
        }
        return this.formatSize(fileSizeInBytes, 0x4000000000000L, "PB");
    }

    private String formatSize(long size, long divider, String unitName) {
        return String.format("%.2f %s", (double)size / (double)divider, unitName);
    }
}

