/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.helpers;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.concurrent.locks.ExclusiveReentrantLockManager;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.order.StatementOrder;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.sail.InterruptedSailException;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UnknownSailTransactionStateException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.CleanerIteration;
import org.eclipse.rdf4j.sail.helpers.SailBaseIteration;
import org.eclipse.rdf4j.sail.helpers.TupleExprWrapperIteration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSailConnection
implements SailConnection {
    private static boolean assertsEnabled = false;
    private static final ConcurrentCleaner cleaner;
    private static final int BLOCK_SIZE = 1000;
    private static final Logger logger;
    private final boolean debugEnabled = AbstractSail.debugEnabled();
    private final AbstractSail sailBase;
    private volatile boolean txnActive;
    private volatile boolean txnPrepared;
    private final LongAdder blockClose = new LongAdder();
    private final LongAdder unblockClose = new LongAdder();
    private final AtomicReference<Thread> activeThread = new AtomicReference();
    private boolean isOpen = true;
    private static final VarHandle IS_OPEN;
    private final Thread owner;
    private final ExclusiveReentrantLockManager updateLock = new ExclusiveReentrantLockManager("AbstractSailConnection-updateLock");
    private final LongAdder iterationsOpened = new LongAdder();
    private final LongAdder iterationsClosed = new LongAdder();
    private final Map<SailBaseIteration<?, ?>, Throwable> activeIterationsDebug;
    private final Map<UpdateContext, Collection<Statement>> removed = new IdentityHashMap<UpdateContext, Collection<Statement>>(0);
    private final Map<UpdateContext, Collection<Statement>> added = new IdentityHashMap<UpdateContext, Collection<Statement>>(0);
    private static final BNode wildContext;
    private IsolationLevel transactionIsolationLevel;
    private volatile boolean statementsAdded;
    private volatile boolean statementsRemoved;

    public AbstractSailConnection(AbstractSail sailBase) {
        this.sailBase = sailBase;
        this.txnActive = false;
        this.activeIterationsDebug = this.debugEnabled ? new ConcurrentHashMap() : Collections.emptyMap();
        this.owner = Thread.currentThread();
    }

    @Override
    public final boolean isOpen() throws SailException {
        return IS_OPEN.getAcquire(this);
    }

    protected void verifyIsOpen() throws SailException {
        if (!IS_OPEN.getAcquire(this)) {
            throw new IllegalStateException("Connection has been closed");
        }
    }

    protected void verifyIsActive() throws SailException {
        if (!this.isActive()) {
            throw new SailException("No active transaction");
        }
    }

    @Override
    public void begin() throws SailException {
        this.begin(this.sailBase.getDefaultIsolationLevel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin(IsolationLevel isolationLevel) throws SailException {
        IsolationLevel compatibleLevel;
        if (isolationLevel == null) {
            isolationLevel = this.sailBase.getDefaultIsolationLevel();
        }
        if ((compatibleLevel = IsolationLevels.getCompatibleIsolationLevel((IsolationLevel)isolationLevel, this.sailBase.getSupportedIsolationLevels())) == null) {
            throw new UnknownSailTransactionStateException("Isolation level " + String.valueOf(isolationLevel) + " not compatible with this Sail");
        }
        this.transactionIsolationLevel = compatibleLevel;
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            Lock exclusiveLock = this.updateLock.getExclusiveLock();
            try {
                if (this.isActive()) {
                    throw new SailException("a transaction is already active on this connection.");
                }
                this.startTransactionInternal();
                this.txnActive = true;
            }
            finally {
                exclusiveLock.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedSailException(e);
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
        this.startUpdate(null);
    }

    protected IsolationLevel getTransactionIsolation() {
        return this.transactionIsolationLevel;
    }

    @Override
    public boolean isActive() throws UnknownSailTransactionStateException {
        return this.transactionActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SailException {
        block51: {
            if (!IS_OPEN.compareAndSet(this, true, false)) {
                return;
            }
            try {
                this.sailBase.connectionClosed(this);
            }
            catch (Throwable throwable) {
                block55: {
                    try {
                        this.waitForOtherOperations(true);
                    }
                    catch (Throwable throwable2) {
                        block57: {
                            try {
                                this.forceCloseActiveOperations();
                                if (!this.txnActive) break block57;
                                logger.warn("Rolling back transaction due to connection close", this.debugEnabled ? new Throwable() : null);
                            }
                            catch (Throwable throwable3) {
                                if (this.txnActive) {
                                    logger.warn("Rolling back transaction due to connection close", this.debugEnabled ? new Throwable() : null);
                                    try {
                                        this.rollbackInternal();
                                    }
                                    finally {
                                        this.txnActive = false;
                                        this.txnPrepared = false;
                                    }
                                }
                                this.closeInternal();
                                if (this.isActiveOperation()) {
                                    throw new SailException("Connection closed before all iterations were closed.");
                                }
                                throw throwable3;
                            }
                            try {
                                this.rollbackInternal();
                            }
                            finally {
                                this.txnActive = false;
                                this.txnPrepared = false;
                            }
                        }
                        this.closeInternal();
                        if (this.isActiveOperation()) {
                            throw new SailException("Connection closed before all iterations were closed.");
                        }
                        throw throwable2;
                    }
                    try {
                        this.forceCloseActiveOperations();
                        if (!this.txnActive) break block55;
                        logger.warn("Rolling back transaction due to connection close", this.debugEnabled ? new Throwable() : null);
                    }
                    catch (Throwable throwable4) {
                        if (this.txnActive) {
                            logger.warn("Rolling back transaction due to connection close", this.debugEnabled ? new Throwable() : null);
                            try {
                                this.rollbackInternal();
                            }
                            finally {
                                this.txnActive = false;
                                this.txnPrepared = false;
                            }
                        }
                        this.closeInternal();
                        if (this.isActiveOperation()) {
                            throw new SailException("Connection closed before all iterations were closed.");
                        }
                        throw throwable4;
                    }
                    try {
                        this.rollbackInternal();
                    }
                    finally {
                        this.txnActive = false;
                        this.txnPrepared = false;
                    }
                }
                this.closeInternal();
                if (this.isActiveOperation()) {
                    throw new SailException("Connection closed before all iterations were closed.");
                }
                throw throwable;
            }
            try {
                this.waitForOtherOperations(true);
            }
            catch (Throwable throwable) {
                block53: {
                    try {
                        this.forceCloseActiveOperations();
                        if (!this.txnActive) break block53;
                        logger.warn("Rolling back transaction due to connection close", this.debugEnabled ? new Throwable() : null);
                    }
                    catch (Throwable throwable5) {
                        if (this.txnActive) {
                            logger.warn("Rolling back transaction due to connection close", this.debugEnabled ? new Throwable() : null);
                            try {
                                this.rollbackInternal();
                            }
                            finally {
                                this.txnActive = false;
                                this.txnPrepared = false;
                            }
                        }
                        this.closeInternal();
                        if (this.isActiveOperation()) {
                            throw new SailException("Connection closed before all iterations were closed.");
                        }
                        throw throwable5;
                    }
                    try {
                        this.rollbackInternal();
                    }
                    finally {
                        this.txnActive = false;
                        this.txnPrepared = false;
                    }
                }
                this.closeInternal();
                if (this.isActiveOperation()) {
                    throw new SailException("Connection closed before all iterations were closed.");
                }
                throw throwable;
            }
            try {
                this.forceCloseActiveOperations();
                if (!this.txnActive) break block51;
                logger.warn("Rolling back transaction due to connection close", this.debugEnabled ? new Throwable() : null);
            }
            catch (Throwable throwable) {
                if (this.txnActive) {
                    logger.warn("Rolling back transaction due to connection close", this.debugEnabled ? new Throwable() : null);
                    try {
                        this.rollbackInternal();
                    }
                    finally {
                        this.txnActive = false;
                        this.txnPrepared = false;
                    }
                }
                this.closeInternal();
                if (this.isActiveOperation()) {
                    throw new SailException("Connection closed before all iterations were closed.");
                }
                throw throwable;
            }
            try {
                this.rollbackInternal();
            }
            finally {
                this.txnActive = false;
                this.txnPrepared = false;
            }
        }
        this.closeInternal();
        if (this.isActiveOperation()) {
            throw new SailException("Connection closed before all iterations were closed.");
        }
    }

    @InternalUseOnly
    public void waitForOtherOperations(boolean interrupt) {
        int i = 0;
        boolean interrupted = false;
        while (true) {
            Thread acquire;
            long sumBlocking;
            long sumDone;
            if ((sumDone = this.unblockClose.sum()) == (sumBlocking = this.blockClose.sum())) {
                if (!interrupted) break;
                logger.warn("Connection is no longer blocked by concurrent operation after interrupting the active thread");
                break;
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new SailException("Connection was interrupted while waiting on concurrent operations before it could be closed.");
            }
            LockSupport.parkNanos(Duration.ofMillis(10L).toNanos());
            if (++i % 500 != 0 || (acquire = this.activeThread.getAcquire()) == null) continue;
            logger.warn("Connection is blocked by concurrent operation in thread: {}", (Object)acquire);
            if (!interrupt) continue;
            acquire.interrupt();
            interrupted = true;
            logger.error("Connection is blocked by concurrent operation in thread {} which was interrupted to attempt to forcefully abort the concurrent operation.", (Object)acquire);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends BindingSet> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.flushPendingUpdates();
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            CloseableIteration<? extends BindingSet> iteration = null;
            try {
                iteration = this.evaluateInternal(tupleExpr, dataset, bindings, includeInferred);
                if (assertsEnabled) {
                    iteration = new TupleExprWrapperIteration(iteration, tupleExpr);
                }
                CloseableIteration<? extends BindingSet> closeableIteration = this.registerIteration(iteration);
                return closeableIteration;
            }
            catch (Throwable t) {
                if (iteration != null) {
                    iteration.close();
                }
                throw t;
            }
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Resource> getContextIDs() throws SailException {
        this.flushPendingUpdates();
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            CloseableIteration<? extends Resource> closeableIteration = this.registerIteration(this.getContextIDsInternal());
            return closeableIteration;
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            CloseableIteration<? extends Statement> iteration = null;
            try {
                iteration = this.getStatementsInternal(subj, pred, obj, includeInferred, contexts);
                CloseableIteration<? extends Statement> closeableIteration = this.registerIteration(iteration);
                return closeableIteration;
            }
            catch (Throwable t) {
                if (iteration != null) {
                    iteration.close();
                }
                throw t;
            }
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    @Override
    public final CloseableIteration<? extends Statement> getStatements(StatementOrder order, Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        this.blockClose.increment();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Statement> iteration = null;
            try {
                iteration = this.getStatementsInternal(order, subj, pred, obj, includeInferred, contexts);
                CloseableIteration<? extends Statement> closeableIteration = this.registerIteration(iteration);
                return closeableIteration;
            }
            catch (Throwable t) {
                if (iteration != null) {
                    iteration.close();
                }
                throw t;
            }
        }
        finally {
            this.unblockClose.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            boolean bl = this.hasStatementInternal(subj, pred, obj, includeInferred, contexts);
            return bl;
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    protected boolean hasStatementInternal(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource[] contexts) {
        try (CloseableIteration<? extends Statement> iteration = this.getStatementsInternal(subj, pred, obj, includeInferred, contexts);){
            boolean bl = iteration.hasNext();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long size(Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            long l = this.sizeInternal(contexts);
            return l;
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    protected final boolean transactionActive() {
        return this.txnActive;
    }

    @Deprecated(since="2.7.0")
    protected void autoStartTransaction() throws SailException {
        this.verifyIsActive();
    }

    @Override
    public void flush() throws SailException {
        if (this.isActive()) {
            this.endUpdate(null);
            this.startUpdate(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void prepare() throws SailException {
        if (this.isActive()) {
            this.endUpdate(null);
        }
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            Lock exclusiveLock = this.updateLock.getExclusiveLock();
            try {
                if (this.txnActive) {
                    this.prepareInternal();
                    this.txnPrepared = true;
                }
            }
            finally {
                exclusiveLock.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedSailException(e);
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void commit() throws SailException {
        if (this.isActive()) {
            this.endUpdate(null);
        }
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            Lock exclusiveLock = this.updateLock.getExclusiveLock();
            try {
                if (this.txnActive) {
                    if (!this.txnPrepared) {
                        this.prepareInternal();
                    }
                    this.commitInternal();
                    this.txnActive = false;
                    this.txnPrepared = false;
                }
            }
            finally {
                exclusiveLock.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedSailException(e);
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rollback() throws SailException {
        block28: {
            Map<UpdateContext, Collection<Statement>> map = this.added;
            synchronized (map) {
                this.added.clear();
            }
            map = this.removed;
            synchronized (map) {
                this.removed.clear();
            }
            this.blockClose.increment();
            try {
                this.activeThread.setRelease(Thread.currentThread());
                this.verifyIsOpen();
                Lock exclusiveLock = null;
                InterruptedException exception = null;
                try {
                    exclusiveLock = this.updateLock.getExclusiveLock();
                }
                catch (InterruptedException e) {
                    logger.warn("Interrupted while trying to acquire exclusive lock to rollback transaction. Retrying one time.", (Throwable)e);
                    exception = e;
                    try {
                        exclusiveLock = this.updateLock.getExclusiveLock();
                    }
                    catch (InterruptedException e2) {
                        assert (false) : "Interrupted a second time while trying to acquire exclusive lock to rollback transaction. This should never happen during testing";
                        logger.error("Interrupted a second time while trying to acquire exclusive lock to rollback transaction. Giving up.", (Throwable)e2);
                        Thread.currentThread().interrupt();
                        throw new InterruptedSailException("Interrupted twice while trying to acquire exclusive lock to rollback transaction.", e);
                    }
                }
                try {
                    if (this.txnActive) {
                        try {
                            this.rollbackInternal();
                            if (exception != null) {
                                Thread.currentThread().interrupt();
                                throw new InterruptedSailException("Interrupted while acquiring lock to allow for rollback. Retried lock and rolled back transaction successfully. Re-interrupted and re-threw exception.", exception);
                            }
                            break block28;
                        }
                        finally {
                            this.txnActive = false;
                            this.txnPrepared = false;
                        }
                    }
                    logger.warn("Cannot rollback transaction on connection because transaction is not active", this.debugEnabled ? new Throwable() : null);
                }
                finally {
                    if (exclusiveLock != null) {
                        exclusiveLock.release();
                    }
                }
            }
            finally {
                try {
                    this.activeThread.setRelease(null);
                }
                finally {
                    this.unblockClose.increment();
                }
            }
        }
    }

    @Override
    public final void addStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.statementsRemoved) {
            this.flushPendingUpdates();
        }
        this.addStatement(null, subj, pred, obj, contexts);
        this.statementsAdded = true;
    }

    @Override
    public final void removeStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        if (this.pendingAdds()) {
            this.flushPendingUpdates();
        }
        this.removeStatement(null, subj, pred, obj, contexts);
        this.statementsRemoved = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUpdate(UpdateContext op) throws SailException {
        if (op != null) {
            this.flushPendingUpdates();
        }
        Map<UpdateContext, Collection<Statement>> map = this.removed;
        synchronized (map) {
            assert (!this.removed.containsKey(op));
            this.removed.put(op, new LinkedList());
        }
        map = this.added;
        synchronized (map) {
            assert (!this.added.containsKey(op));
            this.added.put(op, new LinkedList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatement(UpdateContext op, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, Collection<Statement>> map = this.added;
        synchronized (map) {
            assert (this.added.containsKey(op));
            Collection<Statement> pending = this.added.get(op);
            if (contexts == null || contexts.length == 0) {
                pending.add(this.sailBase.getValueFactory().createStatement(subj, pred, obj));
            } else {
                for (Resource ctx : contexts) {
                    pending.add(this.sailBase.getValueFactory().createStatement(subj, pred, obj, ctx));
                }
            }
            if (pending.size() % 1000 == 0 && !this.isActiveOperation()) {
                this.endUpdate(op);
                this.startUpdate(op);
            }
        }
        this.statementsAdded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatement(UpdateContext op, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, Collection<Statement>> map = this.removed;
        synchronized (map) {
            assert (this.removed.containsKey(op));
            Collection<Statement> pending = this.removed.get(op);
            if (contexts == null) {
                pending.add(new WildStatement(subj, pred, obj));
            } else if (contexts.length == 0) {
                pending.add(new WildStatement(subj, pred, obj, (Resource)wildContext));
            } else {
                for (Resource ctx : contexts) {
                    pending.add(new WildStatement(subj, pred, obj, ctx));
                }
            }
            if (pending.size() % 1000 == 0 && !this.isActiveOperation()) {
                this.endUpdate(op);
                this.startUpdate(op);
            }
        }
        this.statementsRemoved = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void endUpdate(UpdateContext op) throws SailException {
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            Lock exclusiveLock = this.updateLock.getExclusiveLock();
            try {
                this.verifyIsActive();
                this.endUpdateInternal(op);
            }
            finally {
                exclusiveLock.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedSailException(e);
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
            if (op != null) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endUpdateInternal(UpdateContext op) throws SailException {
        Collection<Statement> model;
        Object object = this.removed;
        synchronized (object) {
            model = this.removed.remove(op);
        }
        if (model != null) {
            for (Statement st : model) {
                Resource ctx = st.getContext();
                if (wildContext.equals((Object)ctx)) {
                    this.removeStatementsInternal(st.getSubject(), st.getPredicate(), st.getObject(), new Resource[0]);
                    continue;
                }
                this.removeStatementsInternal(st.getSubject(), st.getPredicate(), st.getObject(), ctx);
            }
        }
        object = this.added;
        synchronized (object) {
            model = this.added.remove(op);
        }
        if (model != null) {
            for (Statement st : model) {
                this.addStatementInternal(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear(Resource ... contexts) throws SailException {
        this.flushPendingUpdates();
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            Lock exclusiveLock = this.updateLock.getExclusiveLock();
            try {
                this.verifyIsActive();
                this.clearInternal(contexts);
                this.statementsRemoved = true;
            }
            finally {
                exclusiveLock.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedSailException(e);
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Namespace> getNamespaces() throws SailException {
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            CloseableIteration<? extends Namespace> closeableIteration = this.registerIteration(this.getNamespacesInternal());
            return closeableIteration;
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getNamespace(String prefix) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            String string = this.getNamespaceInternal(prefix);
            return string;
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setNamespace(String prefix, String name) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            Lock exclusiveLock = this.updateLock.getExclusiveLock();
            try {
                this.verifyIsActive();
                this.setNamespaceInternal(prefix, name);
            }
            finally {
                exclusiveLock.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedSailException(e);
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeNamespace(String prefix) throws SailException {
        if (prefix == null) {
            throw new NullPointerException("prefix must not be null");
        }
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            Lock exclusiveLock = this.updateLock.getExclusiveLock();
            try {
                this.verifyIsActive();
                this.removeNamespaceInternal(prefix);
            }
            finally {
                exclusiveLock.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedSailException(e);
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearNamespaces() throws SailException {
        this.blockClose.increment();
        try {
            this.activeThread.setRelease(Thread.currentThread());
            this.verifyIsOpen();
            Lock exclusiveLock = this.updateLock.getExclusiveLock();
            try {
                this.verifyIsActive();
                this.clearNamespacesInternal();
            }
            finally {
                exclusiveLock.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedSailException(e);
        }
        finally {
            try {
                this.activeThread.setRelease(null);
            }
            finally {
                this.unblockClose.increment();
            }
        }
    }

    protected boolean pendingAdds() {
        return this.statementsAdded;
    }

    protected void setStatementsAdded() {
        this.statementsAdded = true;
    }

    protected void setStatementsRemoved() {
        this.statementsRemoved = true;
    }

    @InternalUseOnly
    public Thread getOwner() {
        return this.owner;
    }

    protected <T, E extends Exception> CloseableIteration<T> registerIteration(CloseableIteration<T> iter) {
        if (iter instanceof EmptyIteration) {
            return iter;
        }
        this.iterationsOpened.increment();
        if (this.debugEnabled) {
            SailBaseIteration result = new SailBaseIteration(iter, this);
            this.activeIterationsDebug.put(result, new Throwable("Unclosed iteration created in " + this.getClass().getName()));
            return result;
        }
        return new CleanerIteration(new SailBaseIteration(iter, this), cleaner);
    }

    protected void iterationClosed(SailBaseIteration<?, ?> iter) {
        if (this.debugEnabled) {
            this.activeIterationsDebug.remove(iter);
        }
        this.iterationsClosed.increment();
    }

    protected abstract void closeInternal() throws SailException;

    protected abstract CloseableIteration<? extends BindingSet> evaluateInternal(TupleExpr var1, Dataset var2, BindingSet var3, boolean var4) throws SailException;

    protected abstract CloseableIteration<? extends Resource> getContextIDsInternal() throws SailException;

    protected abstract CloseableIteration<? extends Statement> getStatementsInternal(Resource var1, IRI var2, Value var3, boolean var4, Resource ... var5) throws SailException;

    protected CloseableIteration<? extends Statement> getStatementsInternal(StatementOrder order, Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        throw new SailException("StatementOrder not supported");
    }

    protected abstract long sizeInternal(Resource ... var1) throws SailException;

    protected abstract void startTransactionInternal() throws SailException;

    protected void prepareInternal() throws SailException {
    }

    protected abstract void commitInternal() throws SailException;

    protected abstract void rollbackInternal() throws SailException;

    protected abstract void addStatementInternal(Resource var1, IRI var2, Value var3, Resource ... var4) throws SailException;

    protected abstract void removeStatementsInternal(Resource var1, IRI var2, Value var3, Resource ... var4) throws SailException;

    protected abstract void clearInternal(Resource ... var1) throws SailException;

    protected abstract CloseableIteration<? extends Namespace> getNamespacesInternal() throws SailException;

    protected abstract String getNamespaceInternal(String var1) throws SailException;

    protected abstract void setNamespaceInternal(String var1, String var2) throws SailException;

    protected abstract void removeNamespaceInternal(String var1) throws SailException;

    protected abstract void clearNamespacesInternal() throws SailException;

    protected boolean isActiveOperation() {
        long opened;
        long closed = this.iterationsClosed.sum();
        return closed != (opened = this.iterationsOpened.sum());
    }

    @InternalUseOnly
    public boolean hasActiveIterations() {
        long opened;
        long closed = this.iterationsClosed.sum();
        return closed != (opened = this.iterationsOpened.sum());
    }

    protected AbstractSail getSailBase() {
        return this.sailBase;
    }

    private void forceCloseActiveOperations() throws SailException {
        for (int i = 0; i < 10 && this.isActiveOperation() && !this.debugEnabled; ++i) {
            System.gc();
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedSailException(e);
            }
        }
        if (this.debugEnabled) {
            IdentityHashMap activeIterationsCopy = new IdentityHashMap(this.activeIterationsDebug);
            this.activeIterationsDebug.clear();
            if (!activeIterationsCopy.isEmpty()) {
                for (Map.Entry<SailBaseIteration<?, ?>, Throwable> entry : activeIterationsCopy.entrySet()) {
                    try {
                        logger.warn("Unclosed iteration", entry.getValue());
                        entry.getKey().close();
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedSailException(e);
                        }
                        logger.warn("Exception occurred while closing unclosed iterations.", (Throwable)e);
                    }
                }
                Map.Entry entry = (Map.Entry)activeIterationsCopy.entrySet().stream().findAny().orElseThrow();
                throw new SailException("Connection closed before all iterations were closed: " + ((Object)((Object)((SailBaseIteration)((Object)entry.getKey())))).toString(), (Throwable)entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPendingUpdates() throws SailException {
        if ((this.statementsAdded || this.statementsRemoved) && this.isActive() && this.isActive()) {
            AbstractSailConnection abstractSailConnection = this;
            synchronized (abstractSailConnection) {
                if ((this.statementsAdded || this.statementsRemoved) && this.isActive()) {
                    this.flush();
                    this.statementsAdded = false;
                    this.statementsRemoved = false;
                }
            }
        }
    }

    static {
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        cleaner = new ConcurrentCleaner();
        logger = LoggerFactory.getLogger(AbstractSailConnection.class);
        wildContext = SimpleValueFactory.getInstance().createBNode();
        try {
            IS_OPEN = MethodHandles.lookup().in(AbstractSailConnection.class).findVarHandle(AbstractSailConnection.class, "isOpen", Boolean.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }

    private static class WildStatement
    implements Statement {
        private static final long serialVersionUID = 3363010521961228565L;
        private final Resource subject;
        private final IRI predicate;
        private final Value object;
        private final Resource context;

        public WildStatement(Resource subject, IRI predicate, Value object) {
            this(subject, predicate, object, null);
        }

        public WildStatement(Resource subject, IRI predicate, Value object, Resource context) {
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
            this.context = context;
        }

        public Resource getSubject() {
            return this.subject;
        }

        public IRI getPredicate() {
            return this.predicate;
        }

        public Value getObject() {
            return this.object;
        }

        public Resource getContext() {
            return this.context;
        }

        public String toString() {
            return "(" + String.valueOf(this.getSubject()) + ", " + String.valueOf(this.getPredicate()) + ", " + String.valueOf(this.getObject()) + ") [" + String.valueOf(this.getContext()) + "]";
        }
    }

    private static class JavaLock
    implements Lock {
        private final java.util.concurrent.locks.Lock javaLock;
        private boolean isActive = true;

        public JavaLock(java.util.concurrent.locks.Lock javaLock) {
            this.javaLock = javaLock;
            javaLock.lock();
        }

        @Override
        public synchronized boolean isActive() {
            return this.isActive;
        }

        @Override
        public synchronized void release() {
            if (this.isActive) {
                this.javaLock.unlock();
                this.isActive = false;
            }
        }
    }
}

