/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.query.resultset.impl;

import com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.model.term.IRIConstant;
import it.unibz.inf.ontop.model.term.ObjectConstant;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import it.unibz.inf.ontop.query.ConstructTemplate;
import it.unibz.inf.ontop.query.resultset.GraphResultSet;
import it.unibz.inf.ontop.query.resultset.OntopBindingSet;
import it.unibz.inf.ontop.query.resultset.OntopCloseableIterator;
import it.unibz.inf.ontop.query.resultset.TupleResultSet;
import it.unibz.inf.ontop.query.resultset.impl.RDFFactCloseableIterator;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.apache.commons.rdf.api.RDF;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;

public class DefaultSimpleGraphResultSet
implements GraphResultSet {
    private final TupleResultSet resultSet;
    private final ConstructTemplate constructTemplate;
    private final TermFactory termFactory;
    private final RDF rdfFactory;
    private final boolean excludeInvalidTriples;
    private final OntopCloseableIterator<RDFFact, OntopConnectionException> iterator;

    public DefaultSimpleGraphResultSet(TupleResultSet tupleResultSet, ConstructTemplate constructTemplate, TermFactory termFactory, RDF rdfFactory, boolean excludeInvalidTriples) {
        this.resultSet = tupleResultSet;
        this.constructTemplate = constructTemplate;
        this.termFactory = termFactory;
        this.rdfFactory = rdfFactory;
        this.excludeInvalidTriples = excludeInvalidTriples;
        this.iterator = new ResultSetIterator();
    }

    public boolean hasNext() throws OntopConnectionException, OntopResultConversionException {
        return this.iterator.hasNext();
    }

    public RDFFact next() throws OntopConnectionException {
        return this.iterator.next();
    }

    public OntopCloseableIterator<RDFFact, OntopConnectionException> iterator() {
        return this.iterator;
    }

    public void close() throws OntopConnectionException {
        this.iterator.close();
    }

    private class ResultSetIterator
    extends RDFFactCloseableIterator {
        private final Queue<RDFFact> statementBuffer = new LinkedList<RDFFact>();
        private final ImmutableMap<String, ValueExpr> extMap;

        private ResultSetIterator() {
            Extension ex = DefaultSimpleGraphResultSet.this.constructTemplate.getExtension();
            this.extMap = ex != null ? (ImmutableMap)ex.getElements().stream().collect(ImmutableCollectors.toMap(ExtensionElem::getName, ExtensionElem::getExpr)) : null;
        }

        public boolean hasNext() throws OntopConnectionException, OntopResultConversionException {
            boolean hasNext;
            this.addStatementFromResultSet();
            boolean bl = hasNext = !this.statementBuffer.isEmpty();
            if (!hasNext) {
                this.handleClose();
            }
            return hasNext;
        }

        public RDFFact next() throws OntopConnectionException {
            if (this.statementBuffer.isEmpty()) {
                this.handleClose();
            }
            return this.statementBuffer.remove();
        }

        public void handleClose() throws OntopConnectionException {
            try {
                if (DefaultSimpleGraphResultSet.this.resultSet.isConnectionAlive()) {
                    DefaultSimpleGraphResultSet.this.resultSet.close();
                }
            }
            catch (Exception e) {
                throw new OntopConnectionException(e);
            }
        }

        private void addStatementFromResultSet() throws OntopConnectionException, OntopResultConversionException {
            while (this.statementBuffer.isEmpty()) {
                if (!DefaultSimpleGraphResultSet.this.resultSet.isConnectionAlive() || !DefaultSimpleGraphResultSet.this.resultSet.hasNext()) {
                    return;
                }
                try {
                    OntopBindingSet bindingSet = (OntopBindingSet)DefaultSimpleGraphResultSet.this.resultSet.next();
                    for (ProjectionElemList peList : DefaultSimpleGraphResultSet.this.constructTemplate.getProjectionElemList()) {
                        List elements = peList.getElements();
                        int size = elements.size();
                        for (int i = 0; i < size / 3; ++i) {
                            try {
                                RDFConstant subjectConstant = this.getConstant((ProjectionElem)elements.get(i * 3), bindingSet);
                                RDFConstant propertyConstant = this.getConstant((ProjectionElem)elements.get(i * 3 + 1), bindingSet);
                                RDFConstant objectConstant = this.getConstant((ProjectionElem)elements.get(i * 3 + 2), bindingSet);
                                if (!(subjectConstant instanceof ObjectConstant) || !(propertyConstant instanceof IRIConstant) || objectConstant == null) continue;
                                this.statementBuffer.add(RDFFact.createTripleFact((ObjectConstant)((ObjectConstant)subjectConstant), (IRIConstant)((IRIConstant)propertyConstant), (RDFConstant)objectConstant));
                                continue;
                            }
                            catch (OntopResultConversionException e) {
                                if (DefaultSimpleGraphResultSet.this.excludeInvalidTriples) continue;
                                throw e;
                            }
                        }
                    }
                }
                catch (OntopResultConversionException e) {
                    if (DefaultSimpleGraphResultSet.this.excludeInvalidTriples) continue;
                    throw e;
                }
            }
        }

        private RDFConstant getConstant(ProjectionElem node, OntopBindingSet bindingSet) throws OntopResultConversionException {
            Object constant;
            ValueExpr ve;
            String nodeName = node.getName();
            ValueExpr valueExpr = ve = this.extMap != null ? (ValueExpr)this.extMap.get((Object)nodeName) : null;
            if (ve instanceof ValueConstant) {
                ValueConstant vc = (ValueConstant)ve;
                constant = vc.getValue() instanceof IRI ? DefaultSimpleGraphResultSet.this.termFactory.getConstantIRI(DefaultSimpleGraphResultSet.this.rdfFactory.createIRI(vc.getValue().stringValue())) : (vc.getValue() instanceof Literal ? DefaultSimpleGraphResultSet.this.termFactory.getRDFLiteralConstant(vc.getValue().stringValue(), XSD.STRING) : DefaultSimpleGraphResultSet.this.termFactory.getConstantBNode(vc.getValue().stringValue()));
            } else if (ve instanceof BNodeGenerator) {
                String rowId = bindingSet.getRowUUIDStr();
                String label = Optional.ofNullable(((BNodeGenerator)ve).getNodeIdExpr()).filter(e -> e instanceof ValueConstant).map(e -> (ValueConstant)e).map(ValueConstant::getValue).map(Value::stringValue).map(s -> s + rowId).orElseGet(() -> nodeName + rowId);
                constant = DefaultSimpleGraphResultSet.this.termFactory.getConstantBNode(label);
            } else {
                constant = bindingSet.getConstant(nodeName);
            }
            return constant;
        }
    }
}

