/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.answering.connection.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.answering.connection.OntopStatement;
import it.unibz.inf.ontop.answering.connection.impl.Evaluator;
import it.unibz.inf.ontop.answering.logging.QueryLogger;
import it.unibz.inf.ontop.answering.reformulation.QueryReformulator;
import it.unibz.inf.ontop.evaluator.QueryContext;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopQueryEvaluationException;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.exception.OntopResultConversionException;
import it.unibz.inf.ontop.exception.OntopUnsupportedInputQueryException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.query.AskQuery;
import it.unibz.inf.ontop.query.ConstructQuery;
import it.unibz.inf.ontop.query.ConstructTemplate;
import it.unibz.inf.ontop.query.DescribeQuery;
import it.unibz.inf.ontop.query.KGQuery;
import it.unibz.inf.ontop.query.SelectQuery;
import it.unibz.inf.ontop.query.resultset.BooleanResultSet;
import it.unibz.inf.ontop.query.resultset.GraphResultSet;
import it.unibz.inf.ontop.query.resultset.OBDAResultSet;
import it.unibz.inf.ontop.query.resultset.TupleResultSet;
import it.unibz.inf.ontop.query.resultset.impl.DefaultDescribeGraphResultSet;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QuestStatement
implements OntopStatement {
    private final QueryReformulator engine;
    private final QueryLogger.Factory queryLoggerFactory;
    private final QueryContext.Factory queryContextFactory;
    private QueryExecutionThread<?, ?> executionThread;
    private boolean canceled = false;
    private static final Logger log = LoggerFactory.getLogger(QuestStatement.class);

    public QuestStatement(QueryReformulator queryProcessor) {
        this.engine = queryProcessor;
        this.queryLoggerFactory = queryProcessor.getQueryLoggerFactory();
        this.queryContextFactory = queryProcessor.getQueryContextFactory();
    }

    private TupleResultSet executeSelectQuery(SelectQuery inputQuery, QueryContext queryContext, QueryLogger queryLogger) throws OntopQueryEvaluationException, OntopReformulationException {
        return this.executeSelectQuery(inputQuery, queryContext, queryLogger, true);
    }

    private TupleResultSet executeSelectQuery(SelectQuery inputQuery, QueryContext queryContext, QueryLogger queryLogger, boolean shouldAlsoCloseStatement) throws OntopQueryEvaluationException, OntopReformulationException {
        IQ executableQuery = this.engine.reformulateIntoNativeQuery((KGQuery)inputQuery, queryContext, queryLogger);
        this.logExecutionStartingMessage();
        return this.executeSelectQuery(executableQuery, queryLogger, shouldAlsoCloseStatement);
    }

    @Override
    public TupleResultSet executeSelectQuery(IQ executableQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException {
        return this.executeSelectQuery(executableQuery, queryLogger, true);
    }

    protected abstract TupleResultSet executeSelectQuery(IQ var1, QueryLogger var2, boolean var3) throws OntopQueryEvaluationException;

    private BooleanResultSet executeBooleanQuery(AskQuery inputQuery, QueryContext queryContext, QueryLogger queryLogger) throws OntopQueryEvaluationException, OntopReformulationException {
        IQ executableQuery = this.engine.reformulateIntoNativeQuery((KGQuery)inputQuery, queryContext, queryLogger);
        this.logExecutionStartingMessage();
        return this.executeBooleanQuery(executableQuery, queryLogger);
    }

    private GraphResultSet executeConstructQuery(ConstructQuery constructQuery, QueryContext queryContext, QueryLogger queryLogger) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException, OntopReformulationException {
        return this.executeConstructQuery(constructQuery, queryContext, queryLogger, true);
    }

    private GraphResultSet executeConstructQuery(ConstructQuery constructQuery, QueryContext queryContext, QueryLogger queryLogger, boolean shouldAlsoCloseStatement) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException, OntopReformulationException {
        IQ executableQuery = this.engine.reformulateIntoNativeQuery((KGQuery)constructQuery, queryContext, queryLogger);
        this.logExecutionStartingMessage();
        return this.executeConstructQuery(constructQuery.getConstructTemplate(), executableQuery, queryLogger, shouldAlsoCloseStatement);
    }

    @Override
    public GraphResultSet executeConstructQuery(ConstructTemplate constructTemplate, IQ executableQuery, QueryLogger queryLogger) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException {
        return this.executeConstructQuery(constructTemplate, executableQuery, queryLogger, true);
    }

    protected abstract GraphResultSet executeConstructQuery(ConstructTemplate var1, IQ var2, QueryLogger var3, boolean var4) throws OntopQueryEvaluationException, OntopResultConversionException, OntopConnectionException;

    protected GraphResultSet executeDescribeQuery(DescribeQuery describeQuery, QueryContext queryContext, QueryLogger queryLogger) throws OntopQueryEvaluationException, OntopConnectionException, OntopReformulationException, OntopResultConversionException {
        return new DefaultDescribeGraphResultSet(describeQuery, queryLogger, this.queryLoggerFactory, queryContext, (selectQuery, qContext, logger) -> this.executeSelectQuery((SelectQuery)selectQuery, qContext, logger, false), (constructQuery, qContext, logger) -> this.executeConstructQuery((ConstructQuery)constructQuery, qContext, logger, false), this::close);
    }

    private void logExecutionStartingMessage() {
        log.debug("Executing the query and get the result...");
    }

    protected abstract void cancelExecution() throws OntopQueryEvaluationException;

    @Override
    public <R extends OBDAResultSet> R execute(KGQuery<R> inputQuery) throws OntopConnectionException, OntopReformulationException, OntopQueryEvaluationException, OntopResultConversionException {
        return this.execute(inputQuery, (ImmutableMultimap<String, String>)ImmutableMultimap.of());
    }

    @Override
    public <R extends OBDAResultSet> R execute(KGQuery<R> inputQuery, ImmutableMultimap<String, String> httpHeaders) throws OntopConnectionException, OntopReformulationException, OntopQueryEvaluationException, OntopResultConversionException {
        if (inputQuery instanceof SelectQuery) {
            return (R)this.executeInThread((SelectQuery)inputQuery, httpHeaders, (inputQuery1, queryContext, queryLogger) -> this.executeSelectQuery((SelectQuery)inputQuery1, queryContext, queryLogger));
        }
        if (inputQuery instanceof AskQuery) {
            return (R)this.executeInThread((AskQuery)inputQuery, httpHeaders, (inputQuery1, queryContext, queryLogger) -> this.executeBooleanQuery((AskQuery)inputQuery1, queryContext, queryLogger));
        }
        if (inputQuery instanceof DescribeQuery) {
            return (R)this.executeInThread((DescribeQuery)inputQuery, httpHeaders, (describeQuery, queryContext, queryLogger) -> this.executeDescribeQuery((DescribeQuery)describeQuery, queryContext, queryLogger));
        }
        if (inputQuery instanceof ConstructQuery) {
            return (R)this.executeInThread((ConstructQuery)inputQuery, httpHeaders, (constructQuery, queryContext, queryLogger) -> this.executeConstructQuery((ConstructQuery)constructQuery, queryContext, queryLogger));
        }
        throw new OntopUnsupportedInputQueryException("Unsupported query type: " + inputQuery);
    }

    private <R extends OBDAResultSet, Q extends KGQuery<R>> R executeInThread(Q inputQuery, ImmutableMultimap<String, String> httpHeaders, Evaluator<R, Q> evaluator) throws OntopReformulationException, OntopQueryEvaluationException {
        QueryExecutionThread executionthread;
        ImmutableMap<String, String> normalizedHttpHeaders = QuestStatement.normalizeHttpHeaders(httpHeaders);
        QueryLogger queryLogger = this.queryLoggerFactory.create(normalizedHttpHeaders);
        queryLogger.setSparqlQuery(inputQuery.getOriginalString());
        QueryContext queryContext = this.queryContextFactory.create(normalizedHttpHeaders);
        CountDownLatch monitor = new CountDownLatch(1);
        this.executionThread = executionthread = new QueryExecutionThread(this, inputQuery, queryLogger, queryContext, evaluator, monitor);
        executionthread.start();
        try {
            monitor.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (executionthread.errorStatus()) {
            Exception ex = executionthread.getException();
            if (ex instanceof OntopReformulationException) {
                throw (OntopReformulationException)ex;
            }
            if (ex instanceof OntopQueryEvaluationException) {
                queryLogger.declareEvaluationException(ex);
                throw (OntopQueryEvaluationException)((Object)ex);
            }
            queryLogger.declareEvaluationException(ex);
            throw new OntopQueryEvaluationException(ex);
        }
        if (this.canceled) {
            this.canceled = false;
            throw new OntopQueryEvaluationException("Query execution was cancelled");
        }
        return executionthread.getResultSet();
    }

    public static ImmutableMap<String, String> normalizeHttpHeaders(ImmutableMultimap<String, String> httpHeaders) {
        return (ImmutableMap)httpHeaders.asMap().entrySet().stream().collect(ImmutableCollectors.toMap(e -> ((String)e.getKey()).toLowerCase(), e -> String.join((CharSequence)",", (Iterable)e.getValue())));
    }

    @Override
    public void cancel() throws OntopConnectionException {
        this.canceled = true;
        try {
            this.executionThread.cancel();
        }
        catch (Exception e) {
            throw new OntopConnectionException(e);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public <R extends OBDAResultSet> String getRewritingRendering(KGQuery<R> query) throws OntopReformulationException {
        return this.engine.getRewritingRendering(query);
    }

    @Override
    public <R extends OBDAResultSet> IQ getExecutableQuery(KGQuery<R> inputQuery, ImmutableMultimap<String, String> httpHeaders) throws OntopReformulationException {
        ImmutableMap<String, String> normalizedHttpHeaders = QuestStatement.normalizeHttpHeaders(httpHeaders);
        return this.engine.reformulateIntoNativeQuery(inputQuery, this.queryContextFactory.create(normalizedHttpHeaders), this.queryLoggerFactory.create(normalizedHttpHeaders));
    }

    private static class QueryExecutionThread<R extends OBDAResultSet, Q extends KGQuery<R>>
    extends Thread {
        private final Q inputQuery;
        private final QueryLogger queryLogger;
        private final QueryContext queryContext;
        private final Evaluator<R, Q> evaluator;
        private final CountDownLatch monitor;
        private R resultSet;
        private Exception exception;
        private boolean executingTargetQuery;
        final /* synthetic */ QuestStatement this$0;

        QueryExecutionThread(Q inputQuery, QueryLogger queryLogger, QueryContext queryContext, Evaluator<R, Q> evaluator, CountDownLatch monitor) {
            this.this$0 = var1_1;
            this.inputQuery = inputQuery;
            this.queryLogger = queryLogger;
            this.queryContext = queryContext;
            this.evaluator = evaluator;
            this.monitor = monitor;
            this.exception = null;
            this.executingTargetQuery = false;
        }

        public boolean errorStatus() {
            return this.exception != null;
        }

        public Exception getException() {
            return this.exception;
        }

        public R getResultSet() {
            return this.resultSet;
        }

        public void cancel() throws OntopQueryEvaluationException {
            this.this$0.canceled = true;
            if (!this.executingTargetQuery) {
                this.stop();
            } else {
                this.this$0.cancelExecution();
            }
        }

        @Override
        public void run() {
            try {
                this.executingTargetQuery = true;
                this.resultSet = this.evaluator.evaluate(this.inputQuery, this.queryContext, this.queryLogger);
                log.debug("Result set unblocked.\n");
            }
            catch (Exception e) {
                this.exception = e;
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.monitor.countDown();
            }
        }
    }
}

