/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.tools.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.tools.UnionBasedQueryMerger;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

@Singleton
public class UnionBasedQueryMergerImpl
implements UnionBasedQueryMerger {
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final CoreUtilsFactory coreUtilsFactory;
    private final QueryTransformerFactory transformerFactory;
    private final IQTreeTools iqTreeTools;

    @Inject
    private UnionBasedQueryMergerImpl(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, CoreUtilsFactory coreUtilsFactory, QueryTransformerFactory transformerFactory, IQTreeTools iqTreeTools) {
        this.iqFactory = iqFactory;
        this.substitutionFactory = substitutionFactory;
        this.coreUtilsFactory = coreUtilsFactory;
        this.transformerFactory = transformerFactory;
        this.iqTreeTools = iqTreeTools;
    }

    @Override
    public Optional<IQ> mergeDefinitions(Collection<IQ> predicateDefinitions) {
        if (predicateDefinitions.isEmpty()) {
            return Optional.empty();
        }
        IQ firstDefinition = predicateDefinitions.iterator().next();
        if (predicateDefinitions.size() == 1) {
            return Optional.of(firstDefinition);
        }
        DistinctVariableOnlyDataAtom projectionAtom = firstDefinition.getProjectionAtom();
        VariableGenerator variableGenerator = this.coreUtilsFactory.createVariableGenerator((Collection)firstDefinition.getTree().getKnownVariables());
        Stream<IQTree> renamedDefinitions = predicateDefinitions.stream().skip(1L).map(def -> {
            InjectiveSubstitution disjointVariableSetRenaming = this.substitutionFactory.generateNotConflictingRenaming(variableGenerator, def.getTree().getKnownVariables());
            if (!def.getProjectionAtom().getPredicate().equals(projectionAtom.getPredicate())) {
                throw new IllegalStateException("Bug: unexpected incompatible atoms");
            }
            ImmutableList sourceProjectionAtomArguments = this.substitutionFactory.apply((Substitution)disjointVariableSetRenaming, def.getProjectionAtom().getArguments());
            InjectiveSubstitution headSubstitution = this.substitutionFactory.getSubstitution(sourceProjectionAtomArguments, projectionAtom.getArguments()).injective();
            InjectiveSubstitution renamingSubstitution = this.substitutionFactory.onVariables().compose((Substitution)headSubstitution, (Substitution)disjointVariableSetRenaming).removeFromDomain((Set)disjointVariableSetRenaming.getRangeSet()).injective();
            return this.transformerFactory.createRenamer(renamingSubstitution).transform(def.getTree());
        });
        ImmutableSet unionVariables = projectionAtom.getVariables();
        ImmutableList unionChildren = (ImmutableList)Stream.concat(Stream.of(firstDefinition.getTree()), renamedDefinitions).map(c -> this.iqTreeTools.createConstructionNodeTreeIfNontrivial(c, unionVariables)).collect(ImmutableCollectors.toList());
        NaryIQTree unionTree = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createUnionNode(unionVariables), unionChildren);
        return Optional.of(this.iqFactory.createIQ(projectionAtom, (IQTree)unionTree));
    }
}

