/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.splitter.impl;

import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.normalization.DistinctNormalizer;
import it.unibz.inf.ontop.iq.optimizer.splitter.ProjectionSplitter;
import it.unibz.inf.ontop.iq.tools.ProjectionDecomposer;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;

public abstract class ProjectionSplitterImpl
implements ProjectionSplitter {
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;
    private final DistinctNormalizer distinctNormalizer;

    protected ProjectionSplitterImpl(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory, DistinctNormalizer distinctNormalizer) {
        this.iqFactory = iqFactory;
        this.substitutionFactory = substitutionFactory;
        this.distinctNormalizer = distinctNormalizer;
    }

    @Override
    public ProjectionSplitter.ProjectionSplit split(IQ initialIQ) {
        return this.split(initialIQ.getTree(), initialIQ.getVariableGenerator());
    }

    protected ProjectionSplitter.ProjectionSplit split(IQ initialIQ, ProjectionDecomposer decomposer) {
        return this.split(initialIQ.getTree(), initialIQ.getVariableGenerator(), decomposer);
    }

    protected ProjectionSplitter.ProjectionSplit split(IQTree topTree, VariableGenerator variableGenerator, ProjectionDecomposer decomposer) {
        return Optional.of(topTree).filter(t -> t.getRootNode() instanceof ConstructionNode).map(t -> (UnaryIQTree)t).map(t -> this.split((UnaryIQTree)t, variableGenerator, decomposer)).orElseGet(() -> new ProjectionSplitImpl(this.iqFactory.createConstructionNode(topTree.getVariables(), this.substitutionFactory.getSubstitution()), topTree, variableGenerator, (ImmutableSet<Variable>)ImmutableSet.of(), (ImmutableSet<ImmutableTerm>)ImmutableSet.of()));
    }

    private ProjectionSplitter.ProjectionSplit split(UnaryIQTree initialTree, VariableGenerator variableGenerator, ProjectionDecomposer decomposer) {
        ConstructionNode initialRootNode = (ConstructionNode)initialTree.getRootNode();
        IQTree initialSubTree = initialTree.getChild();
        ProjectionDecomposer.ProjectionDecomposition decomposition = decomposer.decomposeSubstitution(initialRootNode.getSubstitution(), variableGenerator);
        ConstructionNode postProcessingNode = this.iqFactory.createConstructionNode(initialRootNode.getVariables(), decomposition.getTopSubstitution().orElseGet(() -> ((SubstitutionFactory)this.substitutionFactory).getSubstitution()));
        ImmutableSet newSubTreeVariables = postProcessingNode.getChildVariables();
        IQTree newSubTree = initialSubTree.getVariables().containsAll((Collection)newSubTreeVariables) ? initialSubTree : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)decomposition.getSubSubstitution().map(s -> this.iqFactory.createConstructionNode(newSubTreeVariables, s)).orElseGet(() -> this.iqFactory.createConstructionNode(newSubTreeVariables)), initialSubTree);
        return new ProjectionSplitImpl(postProcessingNode, this.normalizeNewSubTree(newSubTree, variableGenerator), variableGenerator, (ImmutableSet<Variable>)decomposition.getSubSubstitution().map(Substitution::getRangeVariables).orElseGet(ImmutableSet::of), (ImmutableSet<ImmutableTerm>)decomposition.getSubSubstitution().map(Substitution::getRangeSet).orElseGet(ImmutableSet::of));
    }

    protected IQTree normalizeNewSubTree(IQTree newSubTree, VariableGenerator variableGenerator) {
        return Optional.of(newSubTree.getRootNode()).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).map(c -> this.insertConstructionNode(((UnaryIQTree)newSubTree).getChild(), (ConstructionNode)c, variableGenerator)).orElse(newSubTree);
    }

    protected IQTree insertConstructionNode(IQTree tree, ConstructionNode constructionNode, VariableGenerator variableGenerator) {
        QueryNode rootNode = tree.getRootNode();
        if (rootNode instanceof SliceNode) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, this.insertConstructionNode(((UnaryIQTree)tree).getChild(), constructionNode, variableGenerator));
        }
        if (rootNode instanceof DistinctNode) {
            IQTree childTree = ((UnaryIQTree)tree).getChild();
            if (!childTree.getVariables().equals((Object)constructionNode.getChildVariables())) {
                return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, tree);
            }
            DistinctNode distinctNode = (DistinctNode)rootNode;
            UnaryIQTree possibleChildTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, childTree);
            IQTree liftedTree = this.distinctNormalizer.normalizeForOptimization(distinctNode, (IQTree)possibleChildTree, variableGenerator, this.iqFactory.createIQTreeCache());
            return liftedTree.getRootNode().equals(constructionNode) ? this.iqFactory.createUnaryIQTree((UnaryOperatorNode)distinctNode, (IQTree)possibleChildTree) : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, tree);
        }
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, tree);
    }

    static class ProjectionSplitImpl
    implements ProjectionSplitter.ProjectionSplit {
        private final ConstructionNode constructionNode;
        private final IQTree subTree;
        private final VariableGenerator variableGenerator;
        private final ImmutableSet<Variable> pushedVariables;
        private final ImmutableSet<ImmutableTerm> pushedTerms;

        ProjectionSplitImpl(ConstructionNode constructionNode, IQTree subTree, VariableGenerator variableGenerator, ImmutableSet<Variable> pushedVariables, ImmutableSet<ImmutableTerm> pushedTerms) {
            this.constructionNode = constructionNode;
            this.subTree = subTree;
            this.variableGenerator = variableGenerator;
            this.pushedVariables = pushedVariables;
            this.pushedTerms = pushedTerms;
        }

        @Override
        public ConstructionNode getConstructionNode() {
            return this.constructionNode;
        }

        @Override
        public IQTree getSubTree() {
            return this.subTree;
        }

        @Override
        public VariableGenerator getVariableGenerator() {
            return this.variableGenerator;
        }

        @Override
        public ImmutableSet<Variable> getPushedVariables() {
            return this.pushedVariables;
        }

        @Override
        public ImmutableSet<ImmutableTerm> getPushedTerms() {
            return this.pushedTerms;
        }
    }
}

