/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl.lj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.BinaryNonCommutativeIQTree;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.normalization.impl.RightProvenanceNormalizer;
import it.unibz.inf.ontop.iq.optimizer.LeftJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.CardinalitySensitiveJoinTransferLJOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.ComplexStrictEqualityLeftJoinExpliciter;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.LJWithNestingOnRightToInnerJoinOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.LeftJoinAnalysisTools;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

@Singleton
public class MergeLJOptimizer
implements LeftJoinIQOptimizer {
    private final RightProvenanceNormalizer rightProvenanceNormalizer;
    private final CoreSingletons coreSingletons;
    private final IntermediateQueryFactory iqFactory;
    private final CardinalitySensitiveJoinTransferLJOptimizer otherLJOptimizer;
    private final LJWithNestingOnRightToInnerJoinOptimizer ljReductionOptimizer;
    private final ComplexStrictEqualityLeftJoinExpliciter ljConditionExpliciter;

    @Inject
    protected MergeLJOptimizer(RightProvenanceNormalizer rightProvenanceNormalizer, CoreSingletons coreSingletons, CardinalitySensitiveJoinTransferLJOptimizer joinTransferLJOptimizer, LJWithNestingOnRightToInnerJoinOptimizer ljReductionOptimizer, ComplexStrictEqualityLeftJoinExpliciter ljConditionExpliciter) {
        this.rightProvenanceNormalizer = rightProvenanceNormalizer;
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
        this.otherLJOptimizer = joinTransferLJOptimizer;
        this.ljReductionOptimizer = ljReductionOptimizer;
        this.ljConditionExpliciter = ljConditionExpliciter;
    }

    @Override
    public IQ optimize(IQ query) {
        Transformer transformer;
        IQTree initialTree = query.getTree();
        IQTree newTree = initialTree.acceptTransformer((IQTreeVisitingTransformer)(transformer = new Transformer(query.getVariableGenerator(), this.rightProvenanceNormalizer, this.coreSingletons, this.otherLJOptimizer, this.ljReductionOptimizer, this.ljConditionExpliciter)));
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    protected static class RenamingAndUpdatedConditions {
        public final InjectiveSubstitution<Variable> renaming;
        public final Optional<ImmutableExpression> localCondition;
        public final Optional<ImmutableExpression> topCondition;

        protected RenamingAndUpdatedConditions(InjectiveSubstitution<Variable> renaming, Optional<ImmutableExpression> localCondition, Optional<ImmutableExpression> topCondition) {
            this.renaming = renaming;
            this.localCondition = localCondition;
            this.topCondition = topCondition;
        }
    }

    protected static class Ancestor {
        public final LeftJoinNode rootNode;
        public final IQTree right;

        protected Ancestor(LeftJoinNode rootNode, IQTree right) {
            this.rootNode = rootNode;
            this.right = right;
        }
    }

    protected static class Transformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final VariableGenerator variableGenerator;
        private final RightProvenanceNormalizer rightProvenanceNormalizer;
        private final TermFactory termFactory;
        private final CardinalitySensitiveJoinTransferLJOptimizer joinTransferOptimizer;
        private final AtomFactory atomFactory;
        private final SubstitutionFactory substitutionFactory;
        private final LJWithNestingOnRightToInnerJoinOptimizer ljReductionOptimizer;
        private final ComplexStrictEqualityLeftJoinExpliciter ljConditionExpliciter;

        protected Transformer(VariableGenerator variableGenerator, RightProvenanceNormalizer rightProvenanceNormalizer, CoreSingletons coreSingletons, CardinalitySensitiveJoinTransferLJOptimizer joinTransferOptimizer, LJWithNestingOnRightToInnerJoinOptimizer ljReductionOptimizer, ComplexStrictEqualityLeftJoinExpliciter ljConditionExpliciter) {
            super(coreSingletons);
            this.variableGenerator = variableGenerator;
            this.rightProvenanceNormalizer = rightProvenanceNormalizer;
            this.termFactory = coreSingletons.getTermFactory();
            this.joinTransferOptimizer = joinTransferOptimizer;
            this.atomFactory = coreSingletons.getAtomFactory();
            this.substitutionFactory = coreSingletons.getSubstitutionFactory();
            this.ljReductionOptimizer = ljReductionOptimizer;
            this.ljConditionExpliciter = ljConditionExpliciter;
        }

        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            IQTree newLeftChild = this.transform(leftChild);
            IQTree newRightChild = this.transform(rightChild);
            if (!(newLeftChild.getRootNode() instanceof LeftJoinNode)) {
                return this.buildUnoptimizedLJTree(tree, leftChild, rightChild, newLeftChild, newRightChild, rootNode);
            }
            ComplexStrictEqualityLeftJoinExpliciter.LeftJoinNormalization normalization = this.ljConditionExpliciter.makeComplexEqualitiesImplicit(newLeftChild, newRightChild, rootNode.getOptionalFilterCondition(), this.variableGenerator);
            if (!LeftJoinAnalysisTools.tolerateLJConditionLifting(normalization.ljCondition, normalization.leftChild, normalization.rightChild)) {
                return this.buildUnoptimizedLJTree(tree, leftChild, rightChild, newLeftChild, newRightChild, rootNode);
            }
            ImmutableSet rightSpecificVariables = Sets.difference((Set)normalization.rightChild.getVariables(), (Set)normalization.leftChild.getVariables()).immutableCopy();
            Optional<IQTree> simplifiedTree = this.tryToSimplify(normalization.leftChild, normalization.rightChild, normalization.ljCondition, (ImmutableSet<Variable>)rightSpecificVariables, new LinkedList<Ancestor>());
            return simplifiedTree.map(t -> normalization.isIntroducingNewVariables ? this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(tree.getVariables()), t) : t).map(t -> t.normalizeForOptimization(this.variableGenerator)).orElseGet(() -> this.buildUnoptimizedLJTree(tree, leftChild, rightChild, newLeftChild, newRightChild, rootNode));
        }

        private IQTree buildUnoptimizedLJTree(IQTree tree, IQTree leftChild, IQTree rightChild, IQTree newLeftChild, IQTree newRightChild, LeftJoinNode rootNode) {
            return newLeftChild.equals(leftChild) && newRightChild.equals(rightChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, newLeftChild, newRightChild).normalizeForOptimization(this.variableGenerator);
        }

        private Optional<IQTree> tryToSimplify(IQTree leftDescendent, IQTree topRightTree, Optional<ImmutableExpression> topLJCondition, ImmutableSet<Variable> topRightSpecificVariables, List<Ancestor> ancestors) {
            QueryNode leftRootNode = leftDescendent.getRootNode();
            if (!(leftRootNode instanceof LeftJoinNode)) {
                return Optional.empty();
            }
            LeftJoinNode leftJoinNode = (LeftJoinNode)leftRootNode;
            BinaryNonCommutativeIQTree leftJoinTree = (BinaryNonCommutativeIQTree)leftDescendent;
            IQTree leftSubTree = leftJoinTree.getLeftChild();
            IQTree rightSubTree = leftJoinTree.getRightChild();
            ImmutableSet leftVariables = leftSubTree.getVariables();
            if (!Sets.intersection((Set)Sets.difference((Set)rightSubTree.getVariables(), (Set)leftVariables), (Set)topRightTree.getVariables()).isEmpty()) {
                return Optional.empty();
            }
            Optional localLJCondition = leftJoinNode.getOptionalFilterCondition();
            if (!LeftJoinAnalysisTools.tolerateLJConditionLifting(localLJCondition, leftSubTree, rightSubTree) || !this.canBeMerged(rightSubTree, topRightTree, (ImmutableSet<Variable>)leftVariables)) {
                ancestors.add(0, new Ancestor(leftJoinNode, rightSubTree));
                return this.tryToSimplify(leftSubTree, topRightTree, topLJCondition, topRightSpecificVariables, ancestors);
            }
            RenamingAndUpdatedConditions renamingAndUpdatedConditions = this.computeRenaming(localLJCondition, (ImmutableSet<Variable>)leftSubTree.getVariables(), (ImmutableSet<Variable>)rightSubTree.getVariables(), (ImmutableSet<Variable>)topRightTree.getVariables(), topLJCondition, topRightSpecificVariables);
            NaryIQTree mergedLocalRightBeforeRenaming = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(), ImmutableList.of((Object)rightSubTree, (Object)topRightTree));
            Optional<RightProvenanceNormalizer.RightProvenance> localRightProvenance = renamingAndUpdatedConditions.renaming.isEmpty() ? Optional.empty() : Optional.of(this.rightProvenanceNormalizer.normalizeRightProvenance((IQTree)mergedLocalRightBeforeRenaming, leftJoinTree.getVariables(), Optional.empty(), this.variableGenerator));
            IQTree newLocalRightTree = localRightProvenance.map(RightProvenanceNormalizer.RightProvenance::getRightTree).orElse((IQTree)mergedLocalRightBeforeRenaming).applyFreshRenaming(renamingAndUpdatedConditions.renaming);
            BinaryNonCommutativeIQTree newLocalTree = this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)this.iqFactory.createLeftJoinNode(), leftSubTree, newLocalRightTree);
            IQTree newLJTree = ancestors.stream().reduce(newLocalTree, (t, a) -> this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)a.rootNode, t, a.right), (t1, t2) -> {
                throw new MinorOntopInternalBugException("Parallelization is not supported here");
            });
            if (renamingAndUpdatedConditions.renaming.isEmpty()) {
                return Optional.of(newLJTree);
            }
            Substitution newSubstitution = ((InjectiveSubstitution.Builder)renamingAndUpdatedConditions.renaming.builder().removeFromDomain((Set)leftVariables)).transform(v -> v, (t, v) -> this.createIfElseNull((Variable)v, (Variable)t, topRightSpecificVariables, renamingAndUpdatedConditions.localCondition, renamingAndUpdatedConditions.topCondition)).build();
            ImmutableSet projectedVariables = Sets.union((Set)Sets.difference((Set)newLJTree.getVariables(), (Set)renamingAndUpdatedConditions.renaming.getRangeSet()), (Set)newSubstitution.getDomain()).immutableCopy();
            UnaryIQTree newTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(projectedVariables, newSubstitution), newLJTree);
            return Optional.of(newTree);
        }

        private ImmutableFunctionalTerm createIfElseNull(Variable originalVariable, Variable renamedVariable, ImmutableSet<Variable> topRightSpecificVariables, Optional<ImmutableExpression> localLJCondition, Optional<ImmutableExpression> topLJCondition) {
            Optional<ImmutableExpression> condition = topRightSpecificVariables.contains((Object)originalVariable) ? topLJCondition : localLJCondition;
            return condition.map(c -> this.termFactory.getIfElseNull(c, (ImmutableTerm)renamedVariable)).orElseThrow(() -> new MinorOntopInternalBugException("A lj condition was expected"));
        }

        private RenamingAndUpdatedConditions computeRenaming(Optional<ImmutableExpression> localLJCondition, ImmutableSet<Variable> leftVariables, ImmutableSet<Variable> localRightVariables, ImmutableSet<Variable> topRightVariables, Optional<ImmutableExpression> topLJCondition, ImmutableSet<Variable> topRightSpecificVariables) {
            Sets.SetView localRightVariablesOnlySharedWithLeft = Sets.difference((Set)Sets.intersection(leftVariables, localRightVariables), topRightVariables);
            Sets.SetView topRightVariablesOnlySharedWithLeft = Sets.difference((Set)Sets.intersection(leftVariables, topRightVariables), localRightVariables);
            InjectiveSubstitution renaming = (InjectiveSubstitution)Stream.concat(Stream.concat(localLJCondition.isPresent() || !localRightVariablesOnlySharedWithLeft.isEmpty() ? Sets.difference(localRightVariables, leftVariables).stream() : Stream.empty(), topLJCondition.isPresent() || !topRightVariablesOnlySharedWithLeft.isEmpty() ? topRightSpecificVariables.stream() : Stream.empty()), Stream.concat(localRightVariablesOnlySharedWithLeft.stream(), topRightVariablesOnlySharedWithLeft.stream())).distinct().collect(this.substitutionFactory.toFreshRenamingSubstitution(this.variableGenerator));
            Optional newLocalCondition = this.termFactory.getConjunction(localLJCondition.map(arg_0 -> ((InjectiveSubstitution)renaming).apply(arg_0)), this.extractEqualities((Set<Variable>)localRightVariablesOnlySharedWithLeft, (InjectiveSubstitution<Variable>)renaming));
            Optional newTopCondition = this.termFactory.getConjunction(topLJCondition.map(arg_0 -> ((InjectiveSubstitution)renaming).apply(arg_0)), this.extractEqualities((Set<Variable>)topRightVariablesOnlySharedWithLeft, (InjectiveSubstitution<Variable>)renaming));
            return new RenamingAndUpdatedConditions((InjectiveSubstitution<Variable>)renaming, newLocalCondition, newTopCondition);
        }

        private Stream<ImmutableExpression> extractEqualities(Set<Variable> sharedWithLeftVariables, InjectiveSubstitution<Variable> renaming) {
            return sharedWithLeftVariables.stream().map(v -> this.termFactory.getStrictEquality((ImmutableTerm)v, renaming.apply(v), new ImmutableTerm[0]));
        }

        private boolean canBeMerged(IQTree subRightChild, IQTree rightChildToMerge, ImmutableSet<Variable> leftVariables) {
            return this.isTreeIncluded(subRightChild, rightChildToMerge, leftVariables) && this.isTreeIncluded(rightChildToMerge, subRightChild, leftVariables);
        }

        private boolean isTreeIncluded(IQTree tree, IQTree otherTree, ImmutableSet<Variable> leftVariables) {
            RightProvenanceNormalizer.RightProvenance rightProvenance = this.rightProvenanceNormalizer.normalizeRightProvenance(otherTree, tree.getVariables(), Optional.empty(), this.variableGenerator);
            Optional nonNullabilityCondition = this.termFactory.getConjunction(Sets.intersection((Set)tree.getVariables(), leftVariables).stream().map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0)));
            ImmutableExpression isNullCondition = this.termFactory.getDBIsNull((ImmutableTerm)rightProvenance.getProvenanceVariable());
            ImmutableExpression filterCondition = nonNullabilityCondition.map(c -> this.termFactory.getConjunction(isNullCondition, new ImmutableExpression[]{c})).orElse(isNullCondition);
            UnaryIQTree minusTree = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(ImmutableSet.of((Object)rightProvenance.getProvenanceVariable())), (IQTree)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(filterCondition), (IQTree)this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)this.iqFactory.createLeftJoinNode(), tree, rightProvenance.getRightTree())));
            DistinctVariableOnlyDataAtom minusFakeProjectionAtom = this.atomFactory.getDistinctVariableOnlyDataAtom(this.atomFactory.getRDFAnswerPredicate(1), ImmutableList.of((Object)rightProvenance.getProvenanceVariable()));
            IQ minusIQ = this.iqFactory.createIQ(minusFakeProjectionAtom, (IQTree)minusTree);
            IQTree optimizedTree = this.ljReductionOptimizer.optimize(this.joinTransferOptimizer.optimize(minusIQ.normalizeForOptimization())).normalizeForOptimization().getTree();
            return optimizedTree.isDeclaredAsEmpty();
        }
    }
}

